/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa;

import com.github.sniffity.panthalassa.config.PanthalassaClientConfig;
import com.github.sniffity.panthalassa.server.entity.creature.EntityArchelon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityCoelacanth;
import com.github.sniffity.panthalassa.server.entity.creature.EntityDunkleosteus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityKronosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityLeedsichthys;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMegalodon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMosasaurus;
import com.github.sniffity.panthalassa.server.item.ItemPanthalassaSpawnEgg;
import com.github.sniffity.panthalassa.server.network.PanthalassaPacketHandler;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBiomes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaConfiguredStructures;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaFeatures;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItemGroup;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItems;
import com.github.sniffity.panthalassa.server.registry.PanthalassaPOI;
import com.github.sniffity.panthalassa.server.registry.PanthalassaSounds;
import com.github.sniffity.panthalassa.server.registry.PanthalassaStructures;
import com.github.sniffity.panthalassa.server.registry.PanthalassaSurfaceBuilders;
import com.github.sniffity.panthalassa.server.registry.PanthalassaTileEntities;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="panthalassa")
@Mod.EventBusSubscriber(modid="panthalassa", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Panthalassa {
    public static final String MODID = "panthalassa";
    public static final Logger LOGGER = LogManager.getLogger();
    private static Method GETCODEC_METHOD;

    public Panthalassa() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        PanthalassaBlocks.BLOCKS.register(modBus);
        PanthalassaItems.ITEMS.register(modBus);
        PanthalassaTileEntities.TILE_ENTITY_TYPES.register(modBus);
        PanthalassaEntityTypes.ENTITY_TYPES.register(modBus);
        PanthalassaStructures.STRUCTURES.register(modBus);
        PanthalassaBiomes.BIOMES.register(modBus);
        PanthalassaFeatures.FEATURES.register(modBus);
        PanthalassaSurfaceBuilders.SURFACE_BUILDERS.register(modBus);
        PanthalassaSounds.SOUND_EVENTS.register(modBus);
        PanthalassaPOI.POI.register(modBus);
        forgeBus.register(PanthalassaDimension.PANTHALASSA);
        forgeBus.register(PanthalassaDimension.PANTHALASSA_TYPE);
        GeckoLib.initialize();
        forgeBus.register((Object)this);
        modBus.addListener(this::setup);
        modBus.addListener(this::registerEntityAttributes);
        forgeBus.addListener(EventPriority.NORMAL, PanthalassaDimension::worldTick);
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, PanthalassaClientConfig.GENERAL_SPEC, "panthalassa-client-config.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        PanthalassaPacketHandler.register();
        event.enqueueWork(() -> {
            PanthalassaStructures.setupStructures();
            PanthalassaConfiguredStructures.registerConfiguredStructures();
            PanthalassaEntityTypes.spawnPlacements();
            PanthalassaDimension.registerDimensionAccessories();
        });
    }

    public void biomeModification(BiomeLoadingEvent event) {
        event.getGeneration().getStructures().add(() -> PanthalassaConfiguredStructures.CONFIGURED_PANTHALASSA_LABORATORY);
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get(), EntityKronosaurus.kronosaurusAttributes().func_233813_a_());
        event.put((EntityType)PanthalassaEntityTypes.MEGALODON.get(), EntityMegalodon.megalodonAttributes().func_233813_a_());
        event.put((EntityType)PanthalassaEntityTypes.ARCHELON.get(), EntityArchelon.archelonAttributes().func_233813_a_());
        event.put((EntityType)PanthalassaEntityTypes.MOSASAURUS.get(), EntityMosasaurus.mosasaurusAttributes().func_233813_a_());
        event.put((EntityType)PanthalassaEntityTypes.COELACANTH.get(), EntityCoelacanth.coelacanthAttributes().func_233813_a_());
        event.put((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get(), EntityDunkleosteus.dunkleosteusAttributes().func_233813_a_());
        event.put((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get(), EntityLeedsichthys.leedsichthysAttributes().func_233813_a_());
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_201672_e().func_234923_W_() != World.field_234918_g_) {
                return;
            }
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)serverWorld.func_72863_F().field_186029_c, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        PanthalassaBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> event.getRegistry().register(new BlockItem(block, new Item.Properties().func_200916_a(PanthalassaItemGroup.GROUP)).setRegistryName(block.getRegistryName())));
    }

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        ItemPanthalassaSpawnEgg.initUnaddedEggs();
    }
}

