/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client;

import com.github.sniffity.panthalassa.client.events.CameraSetupEvent;
import com.github.sniffity.panthalassa.client.events.KeyInputEvent;
import com.github.sniffity.panthalassa.client.events.RenderTickEvent;
import com.github.sniffity.panthalassa.client.render.entity.RenderArchelon;
import com.github.sniffity.panthalassa.client.render.entity.RenderCoelacanth;
import com.github.sniffity.panthalassa.client.render.entity.RenderDunkleosteus;
import com.github.sniffity.panthalassa.client.render.entity.RenderKronosaurus;
import com.github.sniffity.panthalassa.client.render.entity.RenderLeedsichthys;
import com.github.sniffity.panthalassa.client.render.entity.RenderMegalodon;
import com.github.sniffity.panthalassa.client.render.entity.RenderMosasaurus;
import com.github.sniffity.panthalassa.client.render.vehicle.RenderAGII;
import com.github.sniffity.panthalassa.client.render.vehicle.RenderMRSV;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="panthalassa", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    Minecraft mc = Minecraft.func_71410_x();
    public static final KeyBinding KEY_VEHICLE_LIGHTS = new KeyBinding("key.vehicle.lights", 72, "key.panthalassa.category");
    public static final KeyBinding KEY_VEHICLE_SPECIAL = new KeyBinding("key.vehicle.special", 89, "key.panthalassa.category");
    public static final KeyBinding KEY_VEHICLE_SONAR = new KeyBinding("key.vehicle.sonar", 78, "key.panthalassa.category");

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputEvent());
        MinecraftForge.EVENT_BUS.register((Object)new RenderTickEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CameraSetupEvent());
        ClientHandler.registerEntityRenderers();
        ClientHandler.registerKeybinds();
        ClientHandler.registerBlockColors();
        ClientHandler.registerItemColors();
        ClientHandler.registerBlockRenderers();
    }

    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get()), RenderKronosaurus::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.MEGALODON.get()), RenderMegalodon::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.ARCHELON.get()), RenderArchelon::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.MOSASAURUS.get()), RenderMosasaurus::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.COELACANTH.get()), RenderCoelacanth::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get()), RenderDunkleosteus::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get()), RenderLeedsichthys::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.MRSV.get()), RenderMRSV::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)PanthalassaEntityTypes.AGII.get()), RenderAGII::new);
    }

    public static void registerKeybinds() {
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_VEHICLE_LIGHTS);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_VEHICLE_SPECIAL);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_VEHICLE_SONAR);
    }

    private static void render(Supplier<? extends Block> block, RenderType render) {
        RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType mipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        ClientHandler.render(PanthalassaBlocks.KRETHROSS, cutout);
        ClientHandler.render(PanthalassaBlocks.KRETHROSS_PLANT, cutout);
    }

    public static void registerBlockColors() {
        BlockColors colors = Minecraft.func_71410_x().func_184125_al();
        colors.func_186722_a((state, world, pos, tint) -> world != null && pos != null ? BiomeColors.func_228363_c_((IBlockDisplayReader)world, (BlockPos)pos) : new Color(63, 101, 145).getRGB(), new Block[]{(Block)PanthalassaBlocks.KRETHROSS.get(), (Block)PanthalassaBlocks.KRETHROSS_PLANT.get()});
    }

    public static void registerItemColors() {
        BlockColors bColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors iColors = Minecraft.func_71410_x().getItemColors();
        iColors.func_199877_a((stack, tint) -> bColors.func_228054_a_(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, 0), new IItemProvider[]{(IItemProvider)PanthalassaBlocks.KRETHROSS.get(), (IItemProvider)PanthalassaBlocks.KRETHROSS_PLANT.get()});
        iColors.func_199877_a((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)PanthalassaBlocks.KRETHROSS.get(), (IItemProvider)PanthalassaBlocks.KRETHROSS_PLANT.get()});
    }

    public void setThirdPersonCamera() {
        this.mc.field_71474_y.func_243229_a(PointOfView.THIRD_PERSON_BACK);
    }
}

