/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client.events;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleAGII;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleMRSV;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CameraSetupEvent {
    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity vehicle = mc.field_71439_g.func_184187_bx();
        if (!(vehicle instanceof PanthalassaVehicle)) {
            return;
        }
        PointOfView view = mc.field_71474_y.func_243230_g();
        if (view == PointOfView.THIRD_PERSON_BACK) {
            if (vehicle instanceof VehicleMRSV) {
                event.getInfo().func_216782_a(-CameraSetupEvent.calcCameraDistance(8.0, vehicle), 1.0, 0.0);
            }
            if (vehicle instanceof VehicleAGII) {
                event.getInfo().func_216782_a(-CameraSetupEvent.calcCameraDistance(12.0, vehicle), 1.0, 0.0);
            }
        }
    }

    public static double calcCameraDistance(double startingDistance, Entity vehicle) {
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vector3d position = info.func_216785_c().func_72441_c(0.0, 1.0, 0.0);
        Vector3f view = info.func_227996_l_();
        for (int i = 0; i < 8; ++i) {
            double d0;
            Vector3d vector3d1;
            BlockRayTraceResult raytraceresult;
            float f = (i & 1) * 2 - 1;
            float f1 = (i >> 1 & 1) * 2 - 1;
            float f2 = (i >> 2 & 1) * 2 - 1;
            Vector3d vector3d = position.func_72441_c((double)(f *= 0.1f), (double)(f1 *= 0.1f), (double)(f2 *= 0.1f));
            if ((raytraceresult = vehicle.field_70170_p.func_217299_a(new RayTraceContext(vector3d, vector3d1 = new Vector3d(position.field_72450_a - (double)view.func_195899_a() * startingDistance + (double)f + (double)f2, position.field_72448_b - (double)view.func_195900_b() * startingDistance + (double)f1, position.field_72449_c - (double)view.func_195902_c() * startingDistance + (double)f2), RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, vehicle))).func_216346_c() == RayTraceResult.Type.MISS || !((d0 = raytraceresult.func_216347_e().func_72438_d(position)) < startingDistance)) continue;
            startingDistance = d0;
        }
        return startingDistance;
    }
}

