/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client.events;

import com.github.sniffity.panthalassa.config.PanthalassaClientConfig;
import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleAGII;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleMRSV;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderTickEvent {
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        String vehicleText;
        if (!((Boolean)PanthalassaClientConfig.vehicleOverlayEnabled.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft game = Minecraft.func_71410_x();
        if (!game.func_195544_aj() || game.field_71474_y.field_74319_N) {
            return;
        }
        ClientPlayerEntity player = game.field_71439_g;
        if (player == null) {
            return;
        }
        Entity playerVehicle = player.func_184187_bx();
        if (!(playerVehicle instanceof PanthalassaVehicle)) {
            return;
        }
        MatrixStack matrixStack = new MatrixStack();
        PanthalassaVehicle vehicle = (PanthalassaVehicle)playerVehicle;
        if (vehicle instanceof VehicleMRSV) {
            vehicleText = "MANTA RAY SUBMERSIBLE VEHICLE";
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + vehicleText, 150.0f, 10.0f, Color.WHITE.getRGB());
        }
        if (vehicle instanceof VehicleAGII) {
            vehicleText = "ABYSS GLIDER II SUBMERSIBLE VEHICLE";
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.BOLD + vehicleText, 135.0f, 10.0f, Color.WHITE.getRGB());
        }
        if (vehicle.getMaxHealth() != 0.0f) {
            String vehicleIntegrity = new DecimalFormat("00").format(vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f);
            if (vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f > 50.0f) {
                game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Vehicle Integrity: " + TextFormatting.GREEN + vehicleIntegrity, 10.0f, 25.0f, Color.WHITE.getRGB());
            } else if (vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f > 20.0f) {
                game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Vehicle Integrity: " + TextFormatting.YELLOW + vehicleIntegrity, 10.0f, 25.0f, Color.WHITE.getRGB());
            } else if (vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f > 0.0f) {
                game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Vehicle Integrity: " + TextFormatting.RED + vehicleIntegrity, 10.0f, 25.0f, Color.WHITE.getRGB());
            } else {
                game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Vehicle Integrity: " + TextFormatting.DARK_PURPLE + "processing...", 10.0f, 25.0f, Color.WHITE.getRGB());
            }
        }
        String depth = vehicle.field_70170_p.func_234923_W_() == PanthalassaDimension.PANTHALASSA ? new DecimalFormat("0").format(vehicle.func_233580_cy_().func_177956_o() - 20100) : new DecimalFormat("0").format(vehicle.func_233580_cy_().func_177956_o());
        game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Depth: " + TextFormatting.YELLOW + depth, 10.0f, 35.0f, Color.WHITE.getRGB());
        double x = vehicle.getEntryX();
        double z = vehicle.getEntryZ();
        String entryXText = new DecimalFormat("0").format(x);
        String entryZText = new DecimalFormat("0").format(z);
        if (x != 0.0) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Entry X: " + TextFormatting.YELLOW + entryXText, 10.0f, 55.0f, Color.WHITE.getRGB());
        } else {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Entry X: " + TextFormatting.YELLOW + "???", 10.0f, 55.0f, Color.WHITE.getRGB());
        }
        if (z != 0.0) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Entry Z" + TextFormatting.YELLOW + entryZText, 10.0f, 65.0f, Color.WHITE.getRGB());
        } else {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Entry Z" + TextFormatting.YELLOW + "???", 10.0f, 65.0f, Color.WHITE.getRGB());
        }
        double nlfDistance = vehicle.getNLFDistance();
        String nlfDistanceText = new DecimalFormat("0").format(nlfDistance);
        if (nlfDistance > 10.0) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "NLF Distance: " + TextFormatting.GREEN + nlfDistanceText, 10.0f, 220.0f, Color.WHITE.getRGB());
        } else if (nlfDistance > 5.0) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "NLF Distance: " + TextFormatting.YELLOW + nlfDistanceText, 10.0f, 220.0f, Color.WHITE.getRGB());
        } else if (nlfDistance >= 0.0) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "NLF Distance: " + TextFormatting.RED + nlfDistanceText, 10.0f, 220.0f, Color.WHITE.getRGB());
        } else {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "NLF Distance: " + TextFormatting.DARK_PURPLE + "processing...", 10.0f, 220.0f, Color.WHITE.getRGB());
        }
        int floorDistance = vehicle.getFloorDistance();
        String floorDistanceText = new DecimalFormat("0").format(floorDistance);
        if (floorDistance > 20) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Floor Distance: " + TextFormatting.GREEN + floorDistanceText, 10.0f, 230.0f, Color.WHITE.getRGB());
        } else if (floorDistance > 10) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Floor Distance: " + TextFormatting.YELLOW + floorDistanceText, 10.0f, 230.0f, Color.WHITE.getRGB());
        } else if (floorDistance >= 0) {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Floor Distance: " + TextFormatting.RED + floorDistanceText, 10.0f, 230.0f, Color.WHITE.getRGB());
        } else {
            game.field_71466_p.func_238405_a_(matrixStack, TextFormatting.AQUA + "Floor Distance: " + TextFormatting.DARK_PURPLE + "processing...", 10.0f, 230.0f, Color.WHITE.getRGB());
        }
    }
}

