/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.AnimationUtils;

public class PanthalassaVehicleRenderer<T extends Entity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    private final AnimatedGeoModel<T> modelProvider;

    protected PanthalassaVehicleRenderer(EntityRendererManager renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    public void func_225623_a_(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entityIn));
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-((Entity)entityIn).field_70177_z + 180.0f));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-((Entity)entityIn).field_70125_A));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.func_110775_a(entityIn));
        Color renderColor = this.getRenderColor(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn, this.func_110775_a(entityIn));
        this.render(model, entityIn, partialTicks, renderType, matrixStackIn, bufferIn, null, packedLightIn, PanthalassaVehicleRenderer.getPackedOverlay(entityIn, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        float lastLimbDistance = 0.0f;
        float limbSwing = 0.0f;
        EntityModelData entityModelData = new EntityModelData();
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entityIn, limbSwing, lastLimbDistance, partialTicks, !(lastLimbDistance > -0.15f) || !(lastLimbDistance < 0.15f), Collections.singletonList(entityModelData));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations((IAnimatable)entityIn, this.getUniqueID(entityIn), predicate);
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public static int getPackedOverlay(Entity livingEntityIn, float uIn) {
        return OverlayTexture.func_229201_a_((int)OverlayTexture.func_229199_a_((float)uIn), (int)OverlayTexture.func_229202_a_((boolean)false));
    }

    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public ResourceLocation func_110775_a(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    protected int func_225624_a_(T entityIn, BlockPos partialTicks) {
        return 0;
    }

    static {
        AnimationController.addModelFetcher(object -> object instanceof Entity ? (IAnimatableModel)AnimationUtils.getGeoModelForEntity((Entity)((Entity)object)) : null);
    }
}

