/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.block;

import com.github.sniffity.panthalassa.Panthalassa;
import com.github.sniffity.panthalassa.server.block.BlockPortalTileEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.world.teleporter.PanthalassaTeleporter;
import com.github.sniffity.panthalassa.server.world.teleporter.TeleporterLogic;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockPortal
extends Block
implements ITileEntityProvider {
    private static final VoxelShape portalShape = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);

    public BlockPortal() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(-1.0f, 3600000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(state -> 10).func_200944_c());
    }

    public static void changeDimension(ServerWorld initialWorld, Entity entity, BlockPos portalBlockPos, PanthalassaTeleporter teleporter) {
        ServerWorld targetWorld;
        TileEntity tileEntity = initialWorld.func_175625_s(portalBlockPos);
        if (tileEntity instanceof BlockPortalTileEntity) {
            BlockPortalTileEntity portalTE = (BlockPortalTileEntity)tileEntity;
            targetWorld = initialWorld.func_73046_m().func_71218_a(portalTE.destinationWorld);
            if (targetWorld != null && portalTE.destinationPos != null && targetWorld.func_180495_p(portalTE.destinationPos).func_203425_a((Block)PanthalassaBlocks.PORTAL.get())) {
                TeleporterLogic.teleport(entity, targetWorld, initialWorld, portalTE.destinationPos);
                return;
            }
        }
        RegistryKey<World> targetWorldKey = initialWorld.func_234923_W_() == PanthalassaDimension.PANTHALASSA ? World.field_234918_g_ : PanthalassaDimension.PANTHALASSA;
        targetWorld = initialWorld.func_73046_m().func_71218_a(targetWorldKey);
        if (targetWorld != null) {
            TeleporterLogic.teleportAndCreatePortal(entity, portalBlockPos, targetWorld, initialWorld, teleporter);
            entity.func_242279_ag();
        } else {
            Panthalassa.LOGGER.error("Panthalassa: Portal block is unable to find this dimension for teleporting to: {}", targetWorldKey);
        }
    }

    public TileEntity func_196283_a_(IBlockReader blockReader) {
        return new BlockPortalTileEntity();
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return 5.0f;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d() && this.trySpawnPortal(worldIn, pos)) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return portalShape;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_225541_a_(@Nonnull BlockState state, @Nonnull Fluid fluid) {
        return false;
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        matchShapeSize check = new matchShapeSize((IWorld)world, pos);
        if (check.match) {
            check.createPortalCenter();
            return true;
        }
        return false;
    }

    public boolean tryDestoyPortal(World world, BlockPos pos) {
        matchShapeSize check = new matchShapeSize((IWorld)world, pos);
        if (check.match) {
            check.destroyPortalBlocks();
            return true;
        }
        return false;
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        matchShapeSize check = new matchShapeSize((IWorld)world, pos);
        if ((neighborBlock == this || check.isPanthalassaPortalFrame(neighborBlock.func_176223_P())) && !check.match) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_196262_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (world instanceof ServerWorld && !entity.func_242280_ah()) {
            BlockPortal.changeDimension((ServerWorld)world, entity, pos, new PanthalassaTeleporter((ServerWorld)world));
        }
    }

    public static class matchShapeSize {
        private final IWorld world;
        public boolean match = true;
        BlockPos centerPosition;
        float minPortalFrameRadius = 6.1f;
        float maxPortalFrameRadius = 7.5f;

        public matchShapeSize(IWorld world, BlockPos pos, boolean createPortal) {
            this.world = world;
            if (createPortal) {
                this.centerPosition = pos;
                this.createPortalFrame();
                this.createPortalCenter();
                this.match = true;
            } else {
                int offsetN = this.centerPortal(pos, Direction.NORTH);
                int offsetS = this.centerPortal(pos, Direction.SOUTH);
                int offsetE = this.centerPortal(pos, Direction.EAST);
                int offsetW = this.centerPortal(pos, Direction.WEST);
                this.centerPosition = new BlockPos(pos.func_177958_n() + (offsetE - offsetW) / 2, pos.func_177956_o(), pos.func_177952_p() - (offsetN - offsetS) / 2);
                if (this.match) {
                    this.match = this.checkIfValidPortalFrame(this.centerPosition);
                }
            }
        }

        public matchShapeSize(IWorld world, BlockPos pos) {
            this(world, pos, false);
        }

        public static void recursivelyFindPortalPositions(IWorld world, BlockPos portalCenter, BlockPos currentOffset, Set<BlockPos> savedOffsets) {
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (Direction side : Direction.Plane.HORIZONTAL) {
                mutable.func_189533_g((Vector3i)portalCenter).func_243531_h((Vector3i)currentOffset).func_189536_c(side);
                if (world.func_180495_p((BlockPos)mutable).func_203425_a((Block)PanthalassaBlocks.PORTAL_FRAME.get())) continue;
                mutable.func_189533_g((Vector3i)currentOffset).func_189536_c(side);
                if (savedOffsets.contains(mutable)) continue;
                savedOffsets.add(mutable.func_185334_h());
                matchShapeSize.recursivelyFindPortalPositions(world, portalCenter, mutable.func_185334_h(), savedOffsets);
            }
        }

        boolean isPanthalassaPortalFrame(BlockState state) {
            return state == ((Block)PanthalassaBlocks.PORTAL_FRAME.get()).func_176223_P();
        }

        boolean isWaterOrPortal(BlockState state) {
            return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) || state.getBlockState() == ((Block)PanthalassaBlocks.PORTAL.get()).func_176223_P();
        }

        int centerPortal(BlockPos pos, Direction direction) {
            BlockPos blockpos;
            int distance;
            for (distance = 1; distance < 16 && !this.isPanthalassaPortalFrame(this.world.func_180495_p(blockpos = pos.func_177967_a(direction, distance))); ++distance) {
                if (distance != 15) continue;
                distance = 0;
                blockpos = pos.func_177967_a(direction, distance);
                if (this.isPanthalassaPortalFrame(this.world.func_180495_p(blockpos))) break;
                distance = 15;
                break;
            }
            return distance;
        }

        void destroyPortalBlocks() {
            HashSet<BlockPos> portalPositionsOffsets = new HashSet<BlockPos>();
            portalPositionsOffsets.add(BlockPos.field_177992_a);
            matchShapeSize.recursivelyFindPortalPositions(this.world, this.centerPosition, BlockPos.field_177992_a, portalPositionsOffsets);
            for (BlockPos pos : portalPositionsOffsets) {
                this.world.func_180501_a(this.centerPosition.func_177971_a((Vector3i)pos), Blocks.field_150355_j.func_176223_P(), 2);
            }
        }

        public boolean checkIfValidPortalFrame(BlockPos pos) {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            float maxRadiusSq = this.maxPortalFrameRadius * this.maxPortalFrameRadius;
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            int x = (int)(-this.maxPortalFrameRadius);
            while ((float)x < this.maxPortalFrameRadius) {
                int z = (int)(-this.maxPortalFrameRadius);
                while ((float)z < this.maxPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq > minRadiusSq && (float)distSq < maxRadiusSq) {
                        mutable.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                        if (!this.isPanthalassaPortalFrame(this.world.func_180495_p((BlockPos)mutable))) {
                            return false;
                        }
                    } else if ((float)distSq <= minRadiusSq) {
                        mutable.func_189533_g((Vector3i)pos).func_196234_d(x, 0, z);
                        if (!this.isWaterOrPortal(this.world.func_180495_p((BlockPos)mutable))) {
                            return false;
                        }
                    }
                    ++z;
                }
                ++x;
            }
            return true;
        }

        public void createPortalFrame() {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            float maxRadiusSq = this.maxPortalFrameRadius * this.maxPortalFrameRadius;
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            int x = (int)(-this.maxPortalFrameRadius);
            while ((float)x < this.maxPortalFrameRadius) {
                int z = (int)(-this.maxPortalFrameRadius);
                while ((float)z < this.maxPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq > minRadiusSq && (float)distSq < maxRadiusSq) {
                        mutable.func_189533_g((Vector3i)this.centerPosition).func_196234_d(x, 0, z);
                        this.world.func_180501_a((BlockPos)mutable, ((Block)PanthalassaBlocks.PORTAL_FRAME.get()).func_176223_P(), 2);
                        if (((ServerWorld)this.world).func_234923_W_() == PanthalassaDimension.PANTHALASSA) {
                            while (mutable.func_189536_c(Direction.UP).func_177956_o() < this.world.func_234938_ad_() && !this.world.func_180495_p((BlockPos)mutable).func_203425_a(Blocks.field_150357_h)) {
                                this.world.func_180501_a((BlockPos)mutable, ((Block)PanthalassaBlocks.PANTHALASSA_ROCK.get()).func_176223_P(), 2);
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }

        public void createPortalCenter() {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            int x = (int)(-this.minPortalFrameRadius);
            while ((float)x < this.minPortalFrameRadius) {
                int z = (int)(-this.minPortalFrameRadius);
                while ((float)z < this.minPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq <= minRadiusSq) {
                        mutable.func_189533_g((Vector3i)this.centerPosition).func_196234_d(x, 0, z);
                        this.world.func_180501_a((BlockPos)mutable, ((Block)PanthalassaBlocks.PORTAL.get()).func_176223_P(), 2);
                        TileEntity tileEntity = this.world.func_175625_s((BlockPos)mutable);
                        if (tileEntity instanceof BlockPortalTileEntity) {
                            ((BlockPortalTileEntity)tileEntity).offsetFromCenter = new BlockPos(x, 0, z);
                        }
                        if (((ServerWorld)this.world).func_234923_W_() == PanthalassaDimension.PANTHALASSA) {
                            while (mutable.func_189536_c(Direction.UP).func_177956_o() < this.world.func_234938_ad_() && !this.world.func_180495_p((BlockPos)mutable).func_203425_a(Blocks.field_150357_h) && mutable.func_177956_o() < this.centerPosition.func_177956_o() + 7) {
                                this.world.func_180501_a((BlockPos)mutable, Blocks.field_150355_j.func_176223_P(), 2);
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }

        public void linkPortalCenters(IWorld otherWorld, BlockPos centerOfOtherPortal) {
            float minRadiusSq = this.minPortalFrameRadius * this.minPortalFrameRadius;
            BlockPos.Mutable mutable1 = new BlockPos.Mutable();
            BlockPos.Mutable mutable2 = new BlockPos.Mutable();
            int x = (int)(-this.maxPortalFrameRadius);
            while ((float)x < this.maxPortalFrameRadius) {
                int z = (int)(-this.maxPortalFrameRadius);
                while ((float)z < this.maxPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq <= minRadiusSq) {
                        mutable1.func_189533_g((Vector3i)this.centerPosition).func_196234_d(x, 0, z);
                        mutable2.func_189533_g((Vector3i)centerOfOtherPortal).func_196234_d(x, 0, z);
                        TileEntity tileEntity1 = this.world.func_175625_s((BlockPos)mutable1);
                        TileEntity tileEntity2 = otherWorld.func_175625_s((BlockPos)mutable2);
                        if (tileEntity1 instanceof BlockPortalTileEntity && tileEntity2 instanceof BlockPortalTileEntity) {
                            BlockPortalTileEntity portal1 = (BlockPortalTileEntity)tileEntity1;
                            BlockPortalTileEntity portal2 = (BlockPortalTileEntity)tileEntity2;
                            portal1.destinationPos = portal2.func_174877_v();
                            portal1.destinationWorld = portal2.func_145831_w().func_234923_W_();
                            portal2.destinationPos = portal1.func_174877_v();
                            portal2.destinationWorld = portal1.func_145831_w().func_234923_W_();
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
    }
}

