/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.EntityArchelon;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.ISchoolable;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaEscapeGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaFindWaterGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaMeleeAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaRandomSwimmingGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaSwimmingHelper;
import com.github.sniffity.panthalassa.server.registry.PanthalassaSounds;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityKronosaurus
extends PanthalassaEntity
implements IAnimatable,
IMob,
ISchoolable {
    public static final int BLOCKED_DISTANCE = 3;
    public float prevYRot;
    public float deltaYRot;
    public float adjustYaw;
    public float adjustment = 0.25f;
    protected static final DataParameter<Integer> AIR_SUPPLY = EntityDataManager.func_187226_a(EntityKronosaurus.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> LEADER = EntityDataManager.func_187226_a(EntityKronosaurus.class, (IDataSerializer)DataSerializers.field_187198_h);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EntityKronosaurus(EntityType<? extends PanthalassaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70158_ak = true;
        this.field_70765_h = new PanthalassaSwimmingHelper(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 0.0f);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(AIR_SUPPLY, (Object)150);
        this.field_70180_af.func_187214_a(LEADER, (Object)Boolean.FALSE);
        super.func_70088_a();
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getAttackingState() && !this.field_70729_aU && !((double)this.func_110143_aJ() < 0.01) && !this.func_233643_dh_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.kronosaurus.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.func_213322_ci().func_72433_c() > 0.0 && this.func_70090_H()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.kronosaurus.idle", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)PanthalassaSounds.KRONOSAURUS_AMBIENT.get();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        return super.func_213386_a(world, difficulty, reason, livingdata, compound);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.deltaYRot = this.field_70177_z - this.prevYRot;
        this.prevYRot = this.field_70177_z;
        if (this.adjustYaw > this.deltaYRot) {
            this.adjustYaw -= this.adjustment;
            this.adjustYaw = Math.max(this.adjustYaw, this.deltaYRot);
        } else if (this.adjustYaw < this.deltaYRot) {
            this.adjustYaw += this.adjustment;
            this.adjustYaw = Math.min(this.adjustYaw, this.deltaYRot);
        }
        int i = this.getAirSupplyLocal();
        this.handleAirSupply(i);
    }

    protected void handleAirSupply(int p_209207_1_) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.setAirSupplyLocal(p_209207_1_ - 1);
            if (this.getAirSupplyLocal() == -20) {
                this.setAirSupplyLocal(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.setAirSupplyLocal(150);
        }
    }

    public static AttributeModifierMap.MutableAttribute kronosaurusAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 20.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233818_a_, 125.0).func_233815_a_(Attributes.field_233821_d_, (double)1.3f);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanthalassaFindWaterGoal(this, 0.1f));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanthalassaMeleeAttackGoal(this, 2.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanthalassaEscapeGoal(this, 1.3f));
        this.field_70714_bg.func_75776_a(4, (Goal)new PanthalassaRandomSwimmingGoal(this, 0.7f, 10, 3));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, entity -> entity instanceof PlayerEntity && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && (entity.func_70090_H() || entity.field_70170_p.func_204610_c(entity.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a))));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, entity -> !(entity instanceof PlayerEntity) && !(entity instanceof EntityKronosaurus) && !(entity instanceof EntityArchelon) && (entity.func_70090_H() || entity.field_70170_p.func_204610_c(entity.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a))));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 40, true, false, entity -> entity instanceof EntityArchelon && (entity.func_70090_H() || entity.field_70170_p.func_204610_c(entity.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a))));
    }

    public void setAirSupplyLocal(int airSupply) {
        this.field_70180_af.func_187227_b(AIR_SUPPLY, (Object)airSupply);
    }

    public int getAirSupplyLocal() {
        return (Integer)this.field_70180_af.func_187225_a(AIR_SUPPLY);
    }

    @Override
    public void setLeader(boolean leaderStatus) {
        this.field_70180_af.func_187227_b(LEADER, (Object)leaderStatus);
    }

    @Override
    public boolean getIsLeader() {
        return (Boolean)this.field_70180_af.func_187225_a(LEADER);
    }
}

