/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.EntityArchelon;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.IBreachable;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaBreachAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaEscapeGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaFindWaterGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaMeleeAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaRandomSwimmingGoal;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityMegalodon
extends PanthalassaEntity
implements IAnimatable,
IMob,
IBreachable {
    public static final int BLOCKED_DISTANCE = 3;
    public float prevYRot;
    public float deltaYRot;
    public float adjustYaw;
    public float adjustment = 0.25f;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected static final DataParameter<Boolean> IS_BREACHING = EntityDataManager.func_187226_a(EntityMegalodon.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> BREACH_COOLDOWN = EntityDataManager.func_187226_a(EntityMegalodon.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> AIR_SUPPLY = EntityDataManager.func_187226_a(EntityMegalodon.class, (IDataSerializer)DataSerializers.field_187192_b);

    public EntityMegalodon(EntityType<? extends PanthalassaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70158_ak = true;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getIsBreaching()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.megalodon.breach", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getAttackingState() && !this.field_70729_aU && !((double)this.func_110143_aJ() < 0.01) && !this.func_233643_dh_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.megalodon.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_BREACHING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(BREACH_COOLDOWN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AIR_SUPPLY, (Object)150);
        super.func_70088_a();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBreachCooldown(this.getBreachCooldown() - 1.0f);
        this.deltaYRot = this.field_70177_z - this.prevYRot;
        this.prevYRot = this.field_70177_z;
        if (this.adjustYaw > this.deltaYRot) {
            this.adjustYaw -= this.adjustment;
            this.adjustYaw = Math.max(this.adjustYaw, this.deltaYRot);
        } else if (this.adjustYaw < this.deltaYRot) {
            this.adjustYaw += this.adjustment;
            this.adjustYaw = Math.min(this.adjustYaw, this.deltaYRot);
        }
        int i = this.getAirSupplyLocal();
        this.handleAirSupply(i);
    }

    protected void handleAirSupply(int p_209207_1_) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.setAirSupplyLocal(p_209207_1_ - 1);
            if (this.getAirSupplyLocal() == -20) {
                this.setAirSupplyLocal(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.setAirSupplyLocal(150);
        }
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public double func_70042_X() {
        return 0.2;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, CompoundNBT compound) {
        return super.func_213386_a(world, difficulty, reason, livingdata, compound);
    }

    public static AttributeModifierMap.MutableAttribute megalodonAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 40.0).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233818_a_, 175.0).func_233815_a_(Attributes.field_233821_d_, (double)1.3f);
    }

    public void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanthalassaFindWaterGoal(this, 0.1f));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanthalassaBreachAttackGoal(this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanthalassaMeleeAttackGoal(this, 2.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new PanthalassaEscapeGoal(this, 1.3f));
        this.field_70714_bg.func_75776_a(4, (Goal)new PanthalassaRandomSwimmingGoal(this, 0.9f, 10, 3));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 1, true, false, entity -> entity.func_184187_bx() != null));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, entity -> entity instanceof PlayerEntity && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, true, false, entity -> !(entity instanceof PlayerEntity) && !(entity instanceof EntityMegalodon) && !(entity instanceof EntityArchelon)));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 40, true, false, entity -> entity instanceof EntityArchelon));
        super.func_184651_r();
    }

    @Override
    public void setIsBreaching(boolean breaching) {
        this.field_70180_af.func_187227_b(IS_BREACHING, (Object)breaching);
    }

    @Override
    public boolean getIsBreaching() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BREACHING);
    }

    @Override
    public void setBreachCooldown(float breachCooldown) {
        this.field_70180_af.func_187227_b(BREACH_COOLDOWN, (Object)Float.valueOf(breachCooldown));
    }

    @Override
    public float getBreachCooldown() {
        return ((Float)this.field_70180_af.func_187225_a(BREACH_COOLDOWN)).floatValue();
    }

    public void setAirSupplyLocal(int airSupply) {
        this.field_70180_af.func_187227_b(AIR_SUPPLY, (Object)airSupply);
    }

    public int getAirSupplyLocal() {
        return (Integer)this.field_70180_af.func_187225_a(AIR_SUPPLY);
    }
}

