/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaSwimmingHelper;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class PanthalassaEntity
extends CreatureEntity {
    public boolean isTryingToBreach;
    public boolean isLandNavigator;
    protected static final DataParameter<Boolean> ATTACKING_STATE = EntityDataManager.func_187226_a(PanthalassaEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public PanthalassaEntity(EntityType<? extends PanthalassaEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
        this.switchToLandNavigator(false);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ATTACKING_STATE, (Object)Boolean.FALSE);
        super.func_70088_a();
    }

    public void func_70071_h_() {
        boolean ground;
        super.func_70071_h_();
        boolean bl = ground = !this.func_180799_ab() && !this.func_70090_H() && this.func_233570_aj_();
        if (!ground && this.isLandNavigator) {
            this.switchToLandNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchToLandNavigator(true);
        }
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e();
        int i = 0;
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((LivingEntity)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f)) {
            int j;
            if (i > 0) {
                ((PlayerEntity)entityIn).func_233627_a_((float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            }
            if ((j = EnchantmentHelper.func_90036_a((LivingEntity)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof PlayerEntity) {
                ItemStack itemstack1;
                PlayerEntity entityplayer = (PlayerEntity)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (LivingEntity)entityplayer, (LivingEntity)this) && itemstack1.func_77973_b().isShield(itemstack1, (LivingEntity)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public static boolean canPanthalassaEntitySpawn(EntityType<? extends PanthalassaEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return pos.func_177956_o() > 20 && pos.func_177956_o() < 110;
    }

    public boolean func_205019_a(IWorldReader p_205019_1_) {
        return p_205019_1_.func_72953_d(this.func_174813_aQ());
    }

    public void switchToLandNavigator(boolean isOnLand) {
        if (isOnLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new PanthalassaSwimmingHelper(this);
            this.field_70699_by = new SwimmerPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    public void setAttackingState(boolean isAttacking) {
        this.field_70180_af.func_187227_b(ATTACKING_STATE, (Object)isAttacking);
    }

    public boolean getAttackingState() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING_STATE);
    }
}

