/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.IBreachable;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class PanthalassaBreachAttackGoal
extends Goal {
    protected final IBreachable panthalassaBreachableEntity;
    protected final PanthalassaEntity attacker;
    private final double speedTowardsTarget;
    private boolean step1Done;
    private boolean step2Done;
    private boolean step3Done;
    private boolean step4Done;
    private double jumpStart;
    private double step1Ticks;
    private double step2Ticks;
    private double step3Ticks;
    private double step4Ticks;
    private BlockPos strikePos;

    public PanthalassaBreachAttackGoal(IBreachable creature, double speedIn) {
        this.panthalassaBreachableEntity = creature;
        this.attacker = (PanthalassaEntity)((Object)creature);
        this.speedTowardsTarget = speedIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity target = this.attacker.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (!this.attacker.field_70170_p.func_180495_p(new BlockPos((Vector3i)target.func_233580_cy_().func_177977_b())).func_196957_g((IBlockReader)this.attacker.field_70170_p, new BlockPos((Vector3i)target.func_233580_cy_().func_177977_b()), PathType.WATER)) {
            return false;
        }
        if (!this.attacker.func_70090_H()) {
            return false;
        }
        if (this.panthalassaBreachableEntity.getBreachCooldown() > 0.0f) {
            return false;
        }
        if (this.attacker.field_70170_p.func_234923_W_() == PanthalassaDimension.PANTHALASSA) {
            return false;
        }
        BlockPos targetAbove = new BlockPos(target.func_226277_ct_(), target.func_226278_cu_() + 3.0, target.func_226281_cx_());
        return this.attacker.field_70170_p.func_180495_p(targetAbove).func_203425_a(Blocks.field_150350_a);
    }

    public boolean func_75253_b() {
        LivingEntity target = this.attacker.func_70638_az();
        if (!(this.step3Done || target != null && target.func_70089_S())) {
            return false;
        }
        if (!this.step1Done && !this.attacker.func_70090_H()) {
            return false;
        }
        if (target != null) {
            if (this.attacker.func_70032_d((Entity)target) > 30.0f) {
                return false;
            }
            if (!this.step1Done && !this.attacker.field_70170_p.func_180495_p(new BlockPos((Vector3i)target.func_233580_cy_().func_177979_c(10))).func_196957_g((IBlockReader)this.attacker.field_70170_p, new BlockPos((Vector3i)target.func_233580_cy_().func_177977_b()), PathType.WATER)) {
                return false;
            }
            if (this.step1Done && !this.step2Done && !this.attacker.field_70170_p.func_180495_p(new BlockPos((Vector3i)target.func_233580_cy_().func_177979_c(1))).func_196957_g((IBlockReader)this.attacker.field_70170_p, new BlockPos((Vector3i)target.func_233580_cy_().func_177977_b()), PathType.WATER)) {
                return false;
            }
            if (this.step1Done && !this.step2Done && (!this.attacker.func_70090_H() || this.attacker.func_70032_d((Entity)target) > 20.0f)) {
                return false;
            }
        }
        if (this.step1Ticks > 100.0) {
            return false;
        }
        if (this.step2Ticks > 100.0) {
            return false;
        }
        if (this.step3Done && !this.step4Done && !this.attacker.field_70170_p.func_180495_p(this.strikePos).func_196957_g((IBlockReader)this.attacker.field_70170_p, this.strikePos, PathType.WATER)) {
            return false;
        }
        if (this.step4Ticks > 50.0) {
            return false;
        }
        return !this.step4Done;
    }

    public void func_75249_e() {
        this.attacker.func_213395_q(true);
        this.attacker.isTryingToBreach = true;
    }

    public void func_75251_c() {
        LivingEntity target = this.attacker.func_70638_az();
        if (!EntityPredicates.field_188444_d.test(target)) {
            this.attacker.func_70624_b(null);
        }
        this.attacker.func_213395_q(false);
        this.attacker.isTryingToBreach = false;
        this.panthalassaBreachableEntity.setIsBreaching(false);
        this.panthalassaBreachableEntity.setBreachCooldown(600.0f);
        if (!this.attacker.func_184188_bt().isEmpty()) {
            this.attacker.func_184226_ay();
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        LivingEntity target = this.attacker.func_70638_az();
        if (!this.step1Done && this.moveStep1()) {
            assert (target != null);
            this.attacker.func_70671_ap().func_220679_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            this.step1Done = true;
            this.panthalassaBreachableEntity.setIsBreaching(true);
        }
        if (this.step1Done && !this.step2Done) {
            assert (target != null);
            if (this.moveStep2()) {
                this.step2Done = true;
                this.jumpStart = target.func_226278_cu_();
                if (target.func_184187_bx() != null) {
                    target.func_184187_bx().func_184220_m((Entity)this.attacker);
                } else {
                    target.func_184220_m((Entity)this.attacker);
                }
                if (this.attacker.func_213322_ci().field_72448_b < 1.5) {
                    this.attacker.func_213293_j(this.attacker.func_213322_ci().field_72450_a, 1.5, this.attacker.func_213322_ci().field_72449_c);
                }
            }
        }
        if (this.step1Done && this.step2Done && !this.step3Done) {
            this.step3Ticks = this.step3Ticks += 1.0;
            if (this.attacker.func_226278_cu_() - this.jumpStart > 5.0) {
                this.crushVehicleAndPassengers();
                if (!this.attacker.func_184188_bt().isEmpty()) {
                    this.attacker.func_184226_ay();
                }
                this.panthalassaBreachableEntity.setIsBreaching(false);
                this.step3Done = true;
            } else if (this.step3Ticks > 30.0 && this.attacker.func_70090_H()) {
                this.crushVehicleAndPassengers();
                if (!this.attacker.func_184188_bt().isEmpty()) {
                    this.attacker.func_184226_ay();
                }
                this.step3Done = true;
            }
        }
        if (this.step1Done && this.step2Done && this.step3Done && this.moveStep4()) {
            this.step4Done = true;
        }
    }

    public boolean moveStep1() {
        this.step1Ticks = this.step1Ticks += 1.0;
        LivingEntity target = this.attacker.func_70638_az();
        assert (target != null);
        this.strikePos = target.func_233580_cy_().func_177979_c(12);
        this.attacker.func_70661_as().func_75492_a((double)this.strikePos.func_177958_n(), (double)this.strikePos.func_177956_o(), (double)this.strikePos.func_177952_p(), this.speedTowardsTarget);
        return this.attacker.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_() - 12.0, target.func_226281_cx_()) <= 10.0;
    }

    public boolean moveStep2() {
        this.step2Ticks = this.step2Ticks += 1.0;
        LivingEntity target = this.attacker.func_70638_az();
        assert (target != null);
        this.attacker.func_70671_ap().func_220679_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        this.attacker.func_70661_as().func_75492_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), this.speedTowardsTarget * 4.0);
        return this.attacker.func_70032_d((Entity)target) < 2.0f;
    }

    public boolean moveStep4() {
        this.step4Ticks = this.step4Ticks += 1.0;
        this.attacker.func_70661_as().func_75492_a((double)this.strikePos.func_177958_n(), (double)this.strikePos.func_177956_o(), (double)this.strikePos.func_177952_p(), this.speedTowardsTarget);
        return this.attacker.func_70092_e(this.strikePos.func_177958_n(), this.strikePos.func_177956_o(), this.strikePos.func_177952_p()) <= 20.0;
    }

    protected void crushVehicleAndPassengers() {
        List entities = this.attacker.field_70170_p.func_72839_b((Entity)this.attacker, new AxisAlignedBB(this.attacker.func_226277_ct_() - 5.0, this.attacker.func_226278_cu_() - 3.0, this.attacker.func_226281_cx_() - 5.0, this.attacker.func_226277_ct_() + 5.0, this.attacker.func_226278_cu_() + 10.0, this.attacker.func_226281_cx_() + 5.0));
        if (!entities.isEmpty()) {
            this.attacker.func_184609_a(Hand.MAIN_HAND);
            for (Entity entity : entities) {
                this.attacker.func_70652_k(entity);
            }
        }
    }
}

