/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.block.BlockPortalTileEntity;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.registry.PanthalassaPOI;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class PanthalassaEscapeGoal
extends Goal {
    protected final PanthalassaEntity creature;
    protected final double speed;
    private BlockPos targetPos;
    protected float tickCounter = 0.0f;

    public PanthalassaEscapeGoal(PanthalassaEntity creature, double speed) {
        this.creature = creature;
        this.speed = speed;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.creature.field_70170_p.func_234923_W_() != PanthalassaDimension.PANTHALASSA) {
            return false;
        }
        if (this.creature.func_184207_aI()) {
            return false;
        }
        int searchRadius = 10;
        PointOfInterestManager pointofinterestmanager = ((ServerWorld)this.creature.field_70170_p).func_217443_B();
        Optional portalPOI = pointofinterestmanager.func_219146_b(pointOfInterestType -> pointOfInterestType == PanthalassaPOI.PANTHALASSA_POI_PORTAL.get(), this.creature.func_233580_cy_(), searchRadius, PointOfInterestManager.Status.ANY).findFirst();
        if (portalPOI.isPresent()) {
            BlockPortalTileEntity tempTE = this.getPortalTE((IWorld)this.creature.field_70170_p, ((PointOfInterest)portalPOI.get()).func_218261_f());
            if (tempTE != null) {
                BlockPortalTileEntity centerTE = this.getPortalTE((IWorld)this.creature.field_70170_p, ((PointOfInterest)portalPOI.get()).func_218261_f().func_177973_b((Vector3i)tempTE.offsetFromCenter));
                if (centerTE != null) {
                    this.targetPos = centerTE.func_174877_v();
                    return true;
                }
            } else {
                this.targetPos = null;
                return false;
            }
        }
        this.targetPos = null;
        return false;
    }

    public boolean func_75253_b() {
        if (this.creature.func_184207_aI()) {
            return false;
        }
        if (this.creature.field_70170_p.func_234923_W_() != PanthalassaDimension.PANTHALASSA) {
            return false;
        }
        return !(this.tickCounter > 80.0f);
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p(), this.speed);
    }

    public void func_75246_d() {
        if (this.creature.func_70092_e(this.targetPos.func_177958_n(), this.targetPos.func_177956_o(), this.targetPos.func_177952_p()) < 50.0) {
            Vector3d creaturePos = new Vector3d(this.creature.func_226277_ct_(), this.creature.func_226278_cu_(), this.creature.func_226281_cx_());
            Vector3d target = new Vector3d((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p());
            Vector3d trajectory = target.func_178788_d(creaturePos).func_72432_b();
            this.creature.func_213317_d(this.creature.func_213322_ci().func_72441_c(trajectory.field_72450_a, trajectory.field_72448_b, trajectory.field_72449_c));
        }
        float f = this.tickCounter;
        this.tickCounter = f + 1.0f;
        this.tickCounter = f;
    }

    public void func_75251_c() {
        this.creature.func_70661_as().func_75499_g();
        this.tickCounter = 0.0f;
        super.func_75251_c();
    }

    private BlockPortalTileEntity getPortalTE(IWorld world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BlockPortalTileEntity) {
            return (BlockPortalTileEntity)tileEntity;
        }
        return null;
    }
}

