/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class PanthalassaRandomSwimmingGoal
extends Goal {
    protected final PanthalassaEntity creature;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;
    private boolean checkNoActionTime;
    protected final int avoidDistance;

    public PanthalassaRandomSwimmingGoal(PanthalassaEntity creatureIn, double speedIn, int chance, int avoidDistance) {
        this(creatureIn, speedIn, chance, avoidDistance, false);
    }

    public PanthalassaRandomSwimmingGoal(PanthalassaEntity creature, double speed, int chance, int avoidDistance, boolean checkNATime) {
        this.creature = creature;
        this.speed = speed;
        this.executionChance = chance;
        this.avoidDistance = avoidDistance;
        this.checkNoActionTime = checkNATime;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        Vector3d vector3d;
        if (this.creature.func_184207_aI()) {
            return false;
        }
        if (this.creature.func_70638_az() != null) {
            return false;
        }
        if (!this.creature.func_70090_H()) {
            return false;
        }
        if (!this.mustUpdate) {
            if (this.checkNoActionTime && this.creature.func_70654_ax() >= 100) {
                return false;
            }
            if (this.creature.func_70681_au().nextInt(this.executionChance) != 0) {
                return false;
            }
        }
        if ((vector3d = this.getPosition()) == null) {
            return false;
        }
        this.x = vector3d.field_72450_a;
        this.y = vector3d.field_72448_b;
        this.z = vector3d.field_72449_c;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vector3d getPosition() {
        Vector3d travelVector = new Vector3d(this.creature.func_213322_ci().func_82615_a(), this.creature.func_213322_ci().func_82617_b(), this.creature.func_213322_ci().func_82616_c());
        Vector3d vector = RandomPositionGenerator.func_75464_a((CreatureEntity)this.creature, (int)30, (int)20, (Vector3d)travelVector);
        int i = 0;
        while (vector != null && !this.creature.field_70170_p.func_180495_p(new BlockPos(vector)).func_196957_g((IBlockReader)this.creature.field_70170_p, new BlockPos(vector), PathType.WATER) && i++ < 15) {
            vector = RandomPositionGenerator.func_75464_a((CreatureEntity)this.creature, (int)30, (int)20, (Vector3d)travelVector);
        }
        if (vector != null) {
            Vector3d creaturePos = this.creature.func_213303_ch();
            double distance = creaturePos.func_178788_d(vector).func_72433_c();
            if (distance < 7.0) {
                return null;
            }
            for (int i2 = 0; i2 <= this.avoidDistance; ++i2) {
                if (!this.creature.field_70170_p.func_204610_c(new BlockPos(vector).func_177964_d(i2)).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    vector = null;
                    break;
                }
                if (!this.creature.field_70170_p.func_204610_c(new BlockPos(vector).func_177970_e(i2)).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    vector = null;
                    break;
                }
                if (!this.creature.field_70170_p.func_204610_c(new BlockPos(vector).func_177965_g(i2)).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    vector = null;
                    break;
                }
                if (this.creature.field_70170_p.func_204610_c(new BlockPos(vector).func_177985_f(i2)).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                vector = null;
                break;
            }
        }
        return vector;
    }

    public boolean func_75253_b() {
        if (this.creature.func_70092_e(this.x, this.y, this.z) < 50.0) {
            return false;
        }
        return !this.creature.func_70661_as().func_75500_f() && !this.creature.func_184207_aI();
    }

    public void func_75249_e() {
        this.creature.func_70661_as().func_75492_a(this.x, this.y, this.z, this.speed);
    }

    public void func_75251_c() {
        this.creature.func_70661_as().func_75499_g();
        super.func_75251_c();
    }
}

