/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.ISchoolable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class PanthalassaSchoolingGoal
extends Goal {
    PanthalassaEntity panthalassaEntity;
    ISchoolable panthalassaSchoolableEntity;
    float schoolSpeed;
    float schoolMaxSize;
    float schoolAvoidRadius;
    List<PanthalassaEntity> school;
    PanthalassaEntity leader;

    public PanthalassaSchoolingGoal(PanthalassaEntity creatureIn, float movementSpeedIn, float schoolMaxSize, float schoolAvoidRadius) {
        this.panthalassaEntity = creatureIn;
        this.panthalassaSchoolableEntity = (ISchoolable)((Object)creatureIn);
        this.schoolSpeed = movementSpeedIn;
        this.schoolMaxSize = schoolMaxSize;
        this.schoolAvoidRadius = schoolMaxSize;
    }

    public boolean func_75250_a() {
        this.school = this.panthalassaEntity.field_70170_p.func_217357_a(((Object)((Object)this.panthalassaEntity)).getClass(), this.panthalassaEntity.func_174813_aQ().func_186662_g(10.0));
        if (this.school.size() <= 1) {
            return false;
        }
        if (!this.panthalassaEntity.func_70090_H()) {
            return false;
        }
        for (int i = 0; i < this.school.size(); ++i) {
            PanthalassaEntity testEntity = this.school.get(i);
            if (!((ISchoolable)((Object)testEntity)).getIsLeader()) continue;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.leader == null || this.leader.func_233643_dh_()) {
            return false;
        }
        if (!this.panthalassaEntity.func_70090_H()) {
            return false;
        }
        return this.panthalassaEntity.func_70638_az() == null && this.leader.func_70638_az() == null;
    }

    public void func_75249_e() {
        this.processLeader(this.school);
    }

    public void func_75246_d() {
        Vector3d attract = new Vector3d(0.0, 0.0, 0.0);
        Vector3d repel = new Vector3d(0.0, 0.0, 0.0);
        Vector3d avoid = new Vector3d(0.0, 0.0, 0.0);
        this.school.remove((Object)this.panthalassaEntity);
        if (!this.school.isEmpty()) {
            repel = this.processRepel(this.school);
            Vector3d follow = this.processFollow(this.school);
            avoid = this.processAvoid(this.panthalassaEntity);
            repel = repel.func_72432_b().func_186678_a(1.2);
            follow = follow.func_72432_b().func_186678_a(1.0);
            avoid = avoid.func_72432_b().func_186678_a(1.5);
            Vector3d newMovement = !this.panthalassaSchoolableEntity.getIsLeader() ? this.panthalassaEntity.func_213322_ci().func_178787_e(repel).func_178787_e(follow).func_178787_e(avoid) : this.panthalassaEntity.func_213322_ci().func_178787_e(repel);
            float leaderSpeed = 1.0f;
            if (this.leader != null) {
                leaderSpeed = (float)this.leader.func_213322_ci().func_72433_c();
            }
            if (newMovement.func_72433_c() > (double)leaderSpeed) {
                newMovement = newMovement.func_72432_b().func_186678_a((double)leaderSpeed);
            }
            this.panthalassaEntity.func_213317_d(newMovement);
            if (this.leader != null && !this.panthalassaSchoolableEntity.getIsLeader()) {
                this.panthalassaEntity.func_200602_a(EntityAnchorArgument.Type.EYES, this.panthalassaEntity.func_213303_ch().func_178787_e(this.panthalassaEntity.func_213322_ci()));
            }
        }
    }

    protected void processLeader(List<PanthalassaEntity> school) {
        for (int i = 0; i < school.size(); ++i) {
            PanthalassaEntity testEntity = school.get(i);
            if (!((ISchoolable)((Object)testEntity)).getIsLeader()) continue;
            this.leader = testEntity;
            break;
        }
    }

    protected Vector3d processRepel(List<PanthalassaEntity> school) {
        Vector3d separation = new Vector3d(0.0, 0.0, 0.0);
        ArrayList<PanthalassaEntity> closeEntities = new ArrayList<PanthalassaEntity>();
        int schoolSize = school.size();
        for (int i = 0; i < schoolSize && i < 4; ++i) {
            PanthalassaEntity testEntity = school.get(i);
            float distanceToEntity = (float)this.panthalassaEntity.func_213303_ch().func_178788_d(testEntity.func_213303_ch()).func_72433_c();
            if (!(distanceToEntity < this.schoolAvoidRadius)) continue;
            closeEntities.add(testEntity);
        }
        if (closeEntities.isEmpty()) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        int closeSize = closeEntities.size();
        for (int i = 0; i < closeSize; ++i) {
            PanthalassaEntity testEntity = school.get(i);
            Vector3d difference = this.panthalassaEntity.func_213303_ch().func_178788_d(testEntity.func_213303_ch());
            separation = separation.func_178787_e(difference.func_72432_b().func_186678_a(1.0 / difference.func_72433_c()));
        }
        separation = separation.func_186678_a((double)(1.0f / (float)closeSize));
        Vector3d target = separation.func_72432_b().func_186678_a((double)this.schoolSpeed);
        return target.func_178788_d(this.panthalassaEntity.func_213322_ci());
    }

    protected Vector3d processFollow(List<PanthalassaEntity> school) {
        int size = school.size();
        Vector3d speedVector = new Vector3d(0.0, 0.0, 0.0);
        for (int i = 0; i < size && i < 4; ++i) {
            PanthalassaEntity testEntity = school.get(i);
            if (!((ISchoolable)((Object)testEntity)).getIsLeader()) continue;
            speedVector = testEntity.func_213322_ci();
        }
        Vector3d target = speedVector.func_72432_b().func_186678_a((double)this.schoolSpeed);
        return target.func_178788_d(this.panthalassaEntity.func_213322_ci());
    }

    protected Vector3d processAvoid(PanthalassaEntity entityIn) {
        AxisAlignedBB searchArea = new AxisAlignedBB(entityIn.func_226277_ct_() - 3.0, entityIn.func_226278_cu_() - 3.0, entityIn.func_226281_cx_() - 3.0, entityIn.func_226277_ct_() + 3.0, entityIn.func_226278_cu_() + 3.0, entityIn.func_226281_cx_() + 3.0);
        Set set = BlockPos.func_239581_a_((AxisAlignedBB)searchArea).map(pos -> new BlockPos((Vector3i)pos)).filter(state -> this.panthalassaEntity.field_70170_p.func_180495_p(state).func_200132_m() || this.panthalassaEntity.field_70170_p.func_180495_p(state).func_203425_a(Blocks.field_150350_a)).collect(Collectors.toSet());
        Iterator it = set.iterator();
        if (!set.isEmpty()) {
            BlockPos closestPos = new BlockPos(0, 0, 0);
            float distanceToClosestPos = 100.0f;
            while (it.hasNext()) {
                BlockPos testPos = (BlockPos)it.next();
                float distanceToPos = (float)entityIn.func_213303_ch().func_178786_a((double)testPos.func_177958_n(), (double)testPos.func_177956_o(), (double)testPos.func_177952_p()).func_72433_c();
                if (!(distanceToPos < distanceToClosestPos)) continue;
                distanceToClosestPos = distanceToPos;
                closestPos = new BlockPos(testPos.func_177958_n(), testPos.func_177956_o(), testPos.func_177952_p());
            }
            Vector3d targetAwayFromClosestPos = entityIn.func_213303_ch().func_178786_a((double)closestPos.func_177958_n(), (double)closestPos.func_177956_o(), (double)closestPos.func_177952_p());
            targetAwayFromClosestPos = targetAwayFromClosestPos.func_72432_b();
            return targetAwayFromClosestPos.func_178788_d(entityIn.func_213322_ci());
        }
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public void func_75251_c() {
        this.panthalassaEntity.func_213293_j(0.0, 0.0, 0.0);
        super.func_75251_c();
    }

    protected float rotlerp(float p_75639_1_, float p_75639_2_, float p_75639_3_) {
        float f1;
        float f = MathHelper.func_76142_g((float)(p_75639_2_ - p_75639_1_));
        if (f > p_75639_3_) {
            f = p_75639_3_;
        }
        if (f < -p_75639_3_) {
            f = -p_75639_3_;
        }
        if ((f1 = p_75639_1_ + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }
}

