/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class PanthalassaVehicle
extends Entity {
    protected static final DataParameter<Float> MAX_HEALTH = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> ARMOR = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> NLF_DISTANCE = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> FLOOR_DISTANCE = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> LIGHTS_ON = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SONAR_LAST_CHECK = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> ENTRY_X = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> ENTRY_Z = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LIGHT_X = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LIGHT_Y = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LIGHT_Z = EntityDataManager.func_187226_a(PanthalassaVehicle.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float waterSpeed;
    public float landSpeed;
    public static float aiMoveSpeed;
    protected int newPosRotationIncrements;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected double interpTargetYaw;
    protected double interpTargetPitch;
    public float moveStrafing;
    public float moveVertical;
    public float moveForward;
    public float jumpMovementFactor = 0.02f;
    public float checkedNLFDistance;
    public int checkedFloorDistance;
    public BlockPos prevPos;
    public BlockState blockLightWater = ((Block)PanthalassaBlocks.LIGHT_WATER.get()).func_176223_P();
    public BlockState blockLightAir = ((Block)PanthalassaBlocks.LIGHT_AIR.get()).func_176223_P();
    public RegistryKey<World> prevDimension;

    public PanthalassaVehicle(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(NLF_DISTANCE, (Object)Float.valueOf(-1.0f));
        this.field_70180_af.func_187214_a(FLOOR_DISTANCE, (Object)-1);
        this.field_70180_af.func_187214_a(LIGHTS_ON, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(SONAR_LAST_CHECK, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ENTRY_X, (Object)0);
        this.field_70180_af.func_187214_a(ENTRY_Z, (Object)0);
        this.field_70180_af.func_187214_a(LIGHT_X, (Object)0);
        this.field_70180_af.func_187214_a(LIGHT_Y, (Object)0);
        this.field_70180_af.func_187214_a(LIGHT_Z, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("MaxHealth", 5)) {
            this.setMaxHealth(compound.func_74760_g("MaxHealth"));
        }
        if (compound.func_150297_b("Health", 5)) {
            this.setHealth(compound.func_74760_g("Health"));
        }
        if (compound.func_150297_b("Armor", 5)) {
            this.setArmor(compound.func_74760_g("Armor"));
        }
        if (compound.func_150297_b("NLFDistance", 5)) {
            this.setNLFDistance(compound.func_74760_g("NLFDistance"));
        }
        if (compound.func_150297_b("FloorDistance", 5)) {
            this.setFloorDistance(compound.func_74762_e("FloorDistance"));
        }
        if (compound.func_150297_b("LightsOn", 1)) {
            this.setLightsOn(compound.func_74767_n("LightsOn"));
        }
        if (compound.func_150297_b("SonarLastCheck", 5)) {
            this.setSonarLastCheck(compound.func_74760_g("SonarLastCheck"));
        }
        if (compound.func_150297_b("LightX", 3)) {
            this.setLightPosX(compound.func_74762_e("LightX"));
        }
        if (compound.func_150297_b("LightY", 3)) {
            this.setLightPosY(compound.func_74762_e("LightY"));
        }
        if (compound.func_150297_b("LightZ", 3)) {
            this.setLightPosZ(compound.func_74762_e("LightZ"));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a("MaxHealth", this.getMaxHealth());
        compound.func_74776_a("Health", this.getHealth());
        compound.func_74776_a("Armor", this.getArmor());
        compound.func_74776_a("NLFDistance", this.getNLFDistance());
        compound.func_74768_a("FloorDistance", this.getFloorDistance());
        compound.func_74757_a("LightsOn", this.getLightsOn());
        compound.func_74776_a("SonarLastCheck", this.getSonarLastCheck());
        compound.func_74768_a("LightX", this.getLightPos().func_177958_n());
        compound.func_74768_a("LightY", this.getLightPos().func_177956_o());
        compound.func_74768_a("LightZ", this.getLightPos().func_177952_p());
    }

    public static boolean canVehicleCollide(Entity p_242378_0_, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !p_242378_0_.func_184223_x(entity);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean func_241849_j(Entity entity) {
        return PanthalassaVehicle.canVehicleCollide(this, entity);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.field_72995_K && this.func_184219_q(this)) {
            return player.func_184220_m((Entity)this) ? ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K) : ActionResultType.PASS;
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    protected boolean func_184219_q(Entity vehicle) {
        return this.func_184188_bt().size() < 1;
    }

    @Nullable
    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public float getTravelSpeed() {
        return this.func_70090_H() ? this.waterSpeed : this.landSpeed;
    }

    public float getAIMoveSpeed() {
        return aiMoveSpeed;
    }

    public void setAIMoveSpeed(float speedIn) {
        aiMoveSpeed = speedIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        List passengers = this.func_184188_bt();
        if (this.field_70170_p.func_234923_W_() == PanthalassaDimension.PANTHALASSA && this.prevDimension != PanthalassaDimension.PANTHALASSA) {
            this.setEntryX((int)this.func_213303_ch().field_72450_a);
            this.setEntryZ((int)this.func_213303_ch().field_72449_c);
        } else if (this.prevDimension == PanthalassaDimension.PANTHALASSA && this.field_70170_p.func_234923_W_() != PanthalassaDimension.PANTHALASSA) {
            this.setEntryX(0);
            this.setEntryZ(0);
        }
        if (!passengers.isEmpty()) {
            for (Entity passenger : passengers) {
                LivingEntity currentPassenger = (LivingEntity)passenger;
                currentPassenger.func_195064_c(new EffectInstance(Effects.field_76427_o, 10, 0));
            }
        }
        if (this.prevPos != null) {
            BlockPos prevLight;
            Vector3d prevPosV = new Vector3d((double)this.prevPos.func_177958_n(), (double)this.prevPos.func_177956_o(), (double)this.prevPos.func_177952_p());
            BlockPos vehiclePos = this.func_233580_cy_();
            Vector3d vehiclePosV = new Vector3d((double)vehiclePos.func_177958_n(), (double)vehiclePos.func_177956_o(), (double)vehiclePos.func_177952_p());
            double distanceMoved = prevPosV.func_178788_d(vehiclePosV).func_72433_c();
            boolean hasLooped = false;
            BlockState vehiclePosBlockState = this.field_70170_p.func_180495_p(vehiclePos);
            if ((distanceMoved > 1.0 || !this.func_70090_H() && this.func_233570_aj_() && distanceMoved > 0.2 || !this.getLightsOn()) && (prevLight = this.getLightPos()) != null) {
                if (this.field_70170_p.func_180495_p(prevLight) == this.blockLightWater) {
                    if (this.getLightsOn() && this.func_70090_H()) {
                        this.field_70170_p.func_180501_a(vehiclePos, this.blockLightWater, 2);
                        this.setLightPos(vehiclePos);
                    } else if (this.getLightsOn() && !this.func_70090_H() && this.func_233570_aj_()) {
                        this.field_70170_p.func_180501_a(vehiclePos, this.blockLightAir, 2);
                        this.setLightPos(vehiclePos);
                    }
                    this.field_70170_p.func_180501_a(prevLight, Blocks.field_150355_j.func_176223_P(), 2);
                }
                if (this.field_70170_p.func_180495_p(prevLight) == this.blockLightAir) {
                    if (this.getLightsOn() && !this.func_70090_H() && this.func_233570_aj_()) {
                        this.field_70170_p.func_180501_a(vehiclePos, this.blockLightAir, 2);
                        this.setLightPos(vehiclePos);
                    } else if (this.getLightsOn() && this.func_70090_H()) {
                        this.field_70170_p.func_180501_a(vehiclePos, this.blockLightWater, 2);
                        this.setLightPos(vehiclePos);
                    }
                    this.field_70170_p.func_180501_a(prevLight, Blocks.field_150350_a.func_176223_P(), 2);
                }
                hasLooped = true;
            }
            if (!hasLooped && vehiclePosBlockState != this.blockLightWater && vehiclePosBlockState != this.blockLightAir) {
                prevLight = this.getLightPos();
                if (this.getLightsOn() && this.func_70090_H() && this.field_70170_p.func_180495_p(this.getLightPos()) != ((Block)PanthalassaBlocks.LIGHT_WATER.get()).func_176223_P()) {
                    this.field_70170_p.func_180501_a(vehiclePos, this.blockLightWater, 2);
                    this.setLightPos(vehiclePos);
                    if (prevLight != null) {
                        if (this.field_70170_p.func_180495_p(prevLight) == this.blockLightWater) {
                            this.field_70170_p.func_180501_a(prevLight, Blocks.field_150355_j.func_176223_P(), 2);
                        } else if (this.field_70170_p.func_180495_p(prevLight) == this.blockLightAir) {
                            this.field_70170_p.func_180501_a(prevLight, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                } else if (this.getLightsOn() && !this.func_70090_H() && this.func_233570_aj_() && this.field_70170_p.func_180495_p(this.getLightPos()) != ((Block)PanthalassaBlocks.LIGHT_AIR.get()).func_176223_P()) {
                    this.field_70170_p.func_180501_a(vehiclePos, this.blockLightAir, 2);
                    this.setLightPos(vehiclePos);
                    if (prevLight != null) {
                        if (this.field_70170_p.func_180495_p(prevLight) == this.blockLightWater) {
                            this.field_70170_p.func_180501_a(prevLight, Blocks.field_150355_j.func_176223_P(), 2);
                        } else if (this.field_70170_p.func_180495_p(prevLight) == this.blockLightAir) {
                            this.field_70170_p.func_180501_a(prevLight, Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    }
                }
            }
        }
        this.prevPos = this.func_233580_cy_();
        this.prevDimension = this.field_70170_p.func_234923_W_();
        this.vehicleTick();
    }

    public void vehicleTick() {
        if (this.func_184186_bw()) {
            this.newPosRotationIncrements = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        Vector3d vector3d = this.func_213322_ci();
        double d1 = vector3d.field_72450_a;
        double d3 = vector3d.field_72448_b;
        double d5 = vector3d.field_72449_c;
        if (Math.abs(vector3d.field_72450_a) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vector3d.field_72448_b) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vector3d.field_72449_c) < 0.003) {
            d5 = 0.0;
        }
        this.func_213293_j(d1, d3, d5);
        this.field_70170_p.func_217381_Z().func_76320_a("ai");
        if (this.isServerWorld()) {
            this.field_70170_p.func_217381_Z().func_76320_a("newAi");
            this.updateEntityActionState();
            this.field_70170_p.func_217381_Z().func_76319_b();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("travel");
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.vehicleTravel(new Vector3d((double)this.moveStrafing, (double)this.moveVertical, (double)this.moveForward));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("push");
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    protected void updateEntityActionState() {
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public boolean isServerWorld() {
        return !this.field_70170_p.field_72995_K;
    }

    public void vehicleTravel(Vector3d vec3d) {
        if (this.func_70090_H()) {
            if (this.func_184179_bs() instanceof LivingEntity) {
                float speed = this.getTravelSpeed();
                LivingEntity entity = (LivingEntity)this.func_184179_bs();
                double moveY = vec3d.field_72448_b;
                double moveX = vec3d.field_72450_a;
                double moveZ = entity.field_191988_bg;
                this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                double lookY = entity.func_70040_Z().field_72448_b;
                if (entity.field_191988_bg != 0.0f && (this.func_204231_K() || lookY < 0.0)) {
                    moveY = lookY;
                }
                this.setAIMoveSpeed(speed);
                vec3d = new Vector3d(moveX, moveY, moveZ);
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.003, 0.0));
            }
            this.func_213309_a(this.getAIMoveSpeed(), vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else if (this.func_233570_aj_()) {
            if (this.func_184179_bs() instanceof LivingEntity) {
                float speed = this.getTravelSpeed();
                LivingEntity entity = (LivingEntity)this.func_184179_bs();
                double moveY = vec3d.field_72448_b;
                double moveX = vec3d.field_72450_a;
                double moveZ = entity.field_191988_bg;
                this.field_70177_z = entity.field_70177_z;
                this.setAIMoveSpeed(speed);
                vec3d = new Vector3d(moveX, moveY, moveZ);
            }
            this.func_213309_a(this.getAIMoveSpeed(), vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (vec3d.field_72449_c == 0.0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.003, 0.0));
            }
        } else if (!this.func_233570_aj_()) {
            if (this.func_184179_bs() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)this.func_184179_bs();
                this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
            }
            double d0 = 0.08;
            BlockPos blockpos = this.func_226270_aj_();
            float f3 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).getSlipperiness((IWorldReader)this.field_70170_p, this.func_226270_aj_(), (Entity)this);
            Vector3d vec5 = this.handleRelativeFrictionAndCalculateMovement(vec3d, f3);
            double d2 = vec5.field_72448_b;
            if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                d2 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.func_189652_ae()) {
                d2 -= d0;
            }
            this.func_213293_j(this.func_213322_ci().func_82615_a(), d2 * (double)0.98f, this.func_213322_ci().func_82616_c());
        }
    }

    public Vector3d handleRelativeFrictionAndCalculateMovement(Vector3d vec3d, float d3) {
        this.func_213309_a(this.getRelevantMoveFactor(d3), vec3d);
        this.func_213317_d(this.func_213322_ci());
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        return this.func_213322_ci();
    }

    private float getRelevantMoveFactor(float p_213335_1_) {
        return this.field_70122_E ? this.getAIMoveSpeed() * (0.21600002f / (p_213335_1_ * p_213335_1_ * p_213335_1_)) : this.jumpMovementFactor;
    }

    public boolean func_70097_a(@Nullable DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean isCreativeMode;
            Entity trueSource = source.func_76346_g();
            if (source instanceof IndirectEntityDamageSource && trueSource != null && this.func_184196_w(trueSource)) {
                return false;
            }
            float adjustedAmount = (100.0f - this.getArmor()) / 100.0f > 0.0f ? amount * ((100.0f - this.getArmor()) / 100.0f) : 0.0f;
            this.setHealth(this.getHealth() - adjustedAmount);
            boolean bl = isCreativeMode = trueSource instanceof PlayerEntity && ((PlayerEntity)trueSource).func_184812_l_();
            if (isCreativeMode || this.getHealth() < 0.0f) {
                AxisAlignedBB searchArea = new AxisAlignedBB(this.func_226277_ct_() - 10.0, this.func_226278_cu_() - 10.0, this.func_226281_cx_() - 10.0, this.func_226277_ct_() + 10.0, this.func_226278_cu_() + 10.0, this.func_226281_cx_() + 10.0);
                Set set = BlockPos.func_239581_a_((AxisAlignedBB)searchArea).map(pos -> new BlockPos((Vector3i)pos)).filter(state -> this.field_70170_p.func_180495_p(state) == ((Block)PanthalassaBlocks.LIGHT_WATER.get()).func_176223_P() || this.field_70170_p.func_180495_p(state) == ((Block)PanthalassaBlocks.LIGHT_AIR.get()).func_176223_P()).collect(Collectors.toSet());
                for (BlockPos lightPos : set) {
                    if (this.field_70170_p.func_180495_p(lightPos) == ((Block)PanthalassaBlocks.LIGHT_WATER.get()).func_176223_P()) {
                        this.field_70170_p.func_180501_a(lightPos, Blocks.field_150355_j.func_176223_P(), 2);
                    }
                    if (this.field_70170_p.func_180495_p(lightPos) != ((Block)PanthalassaBlocks.LIGHT_AIR.get()).func_176223_P()) continue;
                    this.field_70170_p.func_180501_a(lightPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void setHealth(float health) {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(Math.min(this.getMaxHealth(), health)));
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue();
    }

    public float getMaxHealth() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_HEALTH)).floatValue();
    }

    public void setMaxHealth(float maxHealth) {
        this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)Float.valueOf(maxHealth));
    }

    public void setArmor(float armor) {
        this.field_70180_af.func_187227_b(ARMOR, (Object)Float.valueOf(armor));
    }

    public float getArmor() {
        return ((Float)this.field_70180_af.func_187225_a(ARMOR)).floatValue();
    }

    public float testNLFDistance(PanthalassaVehicle vehicle) {
        List entities = this.field_70170_p.func_72839_b((Entity)vehicle, new AxisAlignedBB(vehicle.func_226277_ct_() - 20.0, vehicle.func_226278_cu_() - 20.0, vehicle.func_226281_cx_() - 20.0, vehicle.func_226277_ct_() + 20.0, vehicle.func_226278_cu_() + 20.0, vehicle.func_226281_cx_() + 20.0));
        float closestDistance = 100.0f;
        if (entities.size() != 0) {
            for (Entity testEntity : entities) {
                float distance;
                if (!(testEntity instanceof LivingEntity) || testEntity instanceof PlayerEntity || !((distance = this.func_70032_d(testEntity)) < closestDistance)) continue;
                closestDistance = distance;
            }
            if (closestDistance < 20.0f && closestDistance > 0.0f) {
                return closestDistance;
            }
        }
        return -1.0f;
    }

    public void setNLFDistance(float nlfDistance) {
        this.field_70180_af.func_187227_b(NLF_DISTANCE, (Object)Float.valueOf(nlfDistance));
    }

    public float getNLFDistance() {
        return ((Float)this.field_70180_af.func_187225_a(NLF_DISTANCE)).floatValue();
    }

    public int testFloorDistance(PanthalassaVehicle vehicle, World world) {
        BlockPos pos = vehicle.func_233580_cy_();
        while (pos.func_177956_o() > 0) {
            if (!world.func_180495_p(pos).func_200132_m()) {
                pos = pos.func_177977_b();
                continue;
            }
            return vehicle.func_233580_cy_().func_177956_o() - pos.func_177956_o();
        }
        return -1;
    }

    public void setFloorDistance(int floorDistance) {
        this.field_70180_af.func_187227_b(FLOOR_DISTANCE, (Object)floorDistance);
    }

    public int getFloorDistance() {
        return (Integer)this.field_70180_af.func_187225_a(FLOOR_DISTANCE);
    }

    public void setLightsOn(boolean lightState) {
        this.field_70180_af.func_187227_b(LIGHTS_ON, (Object)lightState);
    }

    public boolean getLightsOn() {
        return (Boolean)this.field_70180_af.func_187225_a(LIGHTS_ON);
    }

    public void setSonarLastCheck(float lastCheck) {
        this.field_70180_af.func_187227_b(SONAR_LAST_CHECK, (Object)Float.valueOf(lastCheck));
    }

    public float getSonarLastCheck() {
        return ((Float)this.field_70180_af.func_187225_a(SONAR_LAST_CHECK)).floatValue();
    }

    public void setEntryX(int x) {
        this.field_70180_af.func_187227_b(ENTRY_X, (Object)x);
    }

    public float getEntryX() {
        return ((Integer)this.field_70180_af.func_187225_a(ENTRY_X)).intValue();
    }

    public void setEntryZ(int z) {
        this.field_70180_af.func_187227_b(ENTRY_Z, (Object)z);
    }

    public float getEntryZ() {
        return ((Integer)this.field_70180_af.func_187225_a(ENTRY_Z)).intValue();
    }

    public void setLightPosX(int x) {
        this.field_70180_af.func_187227_b(LIGHT_X, (Object)x);
    }

    public void setLightPosY(int y) {
        this.field_70180_af.func_187227_b(LIGHT_Y, (Object)y);
    }

    public void setLightPosZ(int z) {
        this.field_70180_af.func_187227_b(LIGHT_Z, (Object)z);
    }

    public void setLightPos(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(LIGHT_X, (Object)blockPos.func_177958_n());
        this.field_70180_af.func_187227_b(LIGHT_Y, (Object)blockPos.func_177956_o());
        this.field_70180_af.func_187227_b(LIGHT_Z, (Object)blockPos.func_177952_p());
    }

    public BlockPos getLightPos() {
        BlockPos blockpos = new BlockPos(((Integer)this.field_70180_af.func_187225_a(LIGHT_X)).intValue(), ((Integer)this.field_70180_af.func_187225_a(LIGHT_Y)).intValue(), ((Integer)this.field_70180_af.func_187225_a(LIGHT_Z)).intValue());
        return blockpos;
    }

    public void respondKeybindSpecial() {
    }

    public void respondKeybindSonar() {
        if (!this.func_184188_bt().isEmpty() && (float)this.field_70170_p.func_82737_E() - this.getSonarLastCheck() > 10.0f) {
            this.setSonarLastCheck(this.field_70170_p.func_82737_E());
            this.checkedNLFDistance = this.testNLFDistance(this);
            this.setNLFDistance(this.checkedNLFDistance);
            this.checkedFloorDistance = this.testFloorDistance(this, this.field_70170_p);
            this.setFloorDistance(this.checkedFloorDistance);
        }
    }

    public void respondKeybindLight() {
        this.setLightsOn(!this.getLightsOn());
    }
}

