/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VehicleAGII
extends PanthalassaVehicle
implements IAnimatable {
    public float deltaRotation;
    protected static final DataParameter<Boolean> NET_ACTIVATED = EntityDataManager.func_187226_a(VehicleAGII.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> NET_CATCH = EntityDataManager.func_187226_a(VehicleAGII.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public VehicleAGII(EntityType<? extends PanthalassaVehicle> type, World world) {
        super(type, world);
        this.waterSpeed = 0.04f;
        this.landSpeed = 0.004f;
    }

    public VehicleAGII(World p_i1705_1_, double x, double y, double z) {
        this((EntityType<? extends PanthalassaVehicle>)((EntityType)PanthalassaEntityTypes.AGII.get()), p_i1705_1_);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)Float.valueOf(200.0f));
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(200.0f));
        this.field_70180_af.func_187214_a(ARMOR, (Object)Float.valueOf(40.0f));
        this.field_70180_af.func_187214_a(NET_ACTIVATED, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(NET_CATCH, (Object)Boolean.FALSE);
        super.func_70088_a();
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("netActivated", 1)) {
            this.setNetActivated(compound.func_74767_n("netActivated"));
        }
        if (compound.func_150297_b("netCatch", 1)) {
            this.setNetCatch(compound.func_74767_n("netCatch"));
        }
        super.func_70037_a(compound);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("netActivated", this.getNetActivated());
        compound.func_74757_a("netCatch", this.getNetCatch());
        super.func_213281_b(compound);
    }

    @Override
    protected boolean func_184219_q(Entity vehicle) {
        return this.func_184188_bt().size() < 2;
    }

    public double func_70042_X() {
        return 0.6;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getNetActivated()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ag2.hook_deploy_hold", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void func_70071_h_() {
        if (this.getNetActivated() && this.func_70090_H() && this.func_70089_S() && !this.getNetCatch() && this.attemptNet(this)) {
            this.setNetCatch(true);
        }
        if (!this.getNetActivated() && this.getNetCatch()) {
            if (this.releaseNet(this)) {
                // empty if block
            }
            this.setNetCatch(false);
        }
        List passengers = this.func_184188_bt();
        if (this.getNetCatch() && passengers.size() > 1) {
            LivingEntity netTarget = (LivingEntity)passengers.get(1);
            netTarget.func_195064_c(new EffectInstance(Effects.field_76437_t, 20, 20));
        }
        if (!this.func_184188_bt().isEmpty() && !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
            this.func_184226_ay();
            this.setNetCatch(false);
        }
        super.func_70071_h_();
    }

    @Override
    public void respondKeybindSpecial() {
        if (!this.field_70170_p.field_72995_K) {
            if (!this.getNetActivated() && this.func_70090_H()) {
                this.setNetActivated(true);
            } else if (this.getNetActivated()) {
                this.setNetActivated(false);
            }
        }
    }

    @Override
    public float getTravelSpeed() {
        if (this.getNetActivated() && this.func_70090_H()) {
            return this.waterSpeed * 0.8f;
        }
        if (this.func_70090_H()) {
            return this.waterSpeed;
        }
        return this.landSpeed;
    }

    public boolean attemptNet(PanthalassaVehicle vehicle) {
        if (!this.getNetCatch() && this.getNetActivated()) {
            List entities = this.field_70170_p.func_72839_b((Entity)vehicle, new AxisAlignedBB(vehicle.func_226277_ct_() - 5.0, vehicle.func_226278_cu_() - 5.0, vehicle.func_226281_cx_() - 5.0, vehicle.func_226277_ct_() + 5.0, vehicle.func_226278_cu_() + 5.0, vehicle.func_226281_cx_() + 5.0));
            float closestDistance = 100.0f;
            if (entities.size() != 0) {
                for (Entity testEntity : entities) {
                    if (!(testEntity instanceof LivingEntity) || testEntity instanceof PlayerEntity || testEntity.func_184187_bx() != null) continue;
                    float distance = this.func_70032_d(testEntity);
                    if (distance < closestDistance) {
                        closestDistance = distance;
                        if (!(closestDistance < 5.0f)) continue;
                        testEntity.func_184220_m((Entity)this);
                        if (this.func_184188_bt().isEmpty()) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public boolean releaseNet(PanthalassaVehicle vehicle) {
        List passengers = this.func_184188_bt();
        if (this.getNetCatch() && !this.getNetActivated() && passengers.size() > 1) {
            ((Entity)passengers.get(1)).func_184210_p();
            return true;
        }
        return false;
    }

    public void setNetActivated(boolean active) {
        this.field_70180_af.func_187227_b(NET_ACTIVATED, (Object)active);
    }

    public boolean getNetActivated() {
        return (Boolean)this.field_70180_af.func_187225_a(NET_ACTIVATED);
    }

    public void setNetCatch(boolean target) {
        this.field_70180_af.func_187227_b(NET_CATCH, (Object)target);
    }

    public boolean getNetCatch() {
        return (Boolean)this.field_70180_af.func_187225_a(NET_CATCH);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((!this.func_70089_S() ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            float f2 = 0.06f;
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                if (i == 0) {
                    f = 0.0f;
                    f2 = 0.0f;
                } else {
                    f = -1.0f;
                    f2 = -2.0f;
                }
            }
            Vector3d vector3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1 + (double)f2, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
        }
    }
}

