/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VehicleMRSV
extends PanthalassaVehicle
implements IAnimatable {
    protected static final DataParameter<Boolean> IS_BOOSTING = EntityDataManager.func_187226_a(VehicleMRSV.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> BOOST_COOLDOWN = EntityDataManager.func_187226_a(VehicleMRSV.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> BOOSTING_TIMER = EntityDataManager.func_187226_a(VehicleMRSV.class, (IDataSerializer)DataSerializers.field_187193_c);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public VehicleMRSV(EntityType<? extends PanthalassaVehicle> type, World world) {
        super(type, world);
        this.waterSpeed = 0.05f;
        this.landSpeed = 0.004f;
    }

    public VehicleMRSV(World p_i1705_1_, double x, double y, double z) {
        this((EntityType<? extends PanthalassaVehicle>)((EntityType)PanthalassaEntityTypes.MRSV.get()), p_i1705_1_);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)Float.valueOf(100.0f));
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(100.0f));
        this.field_70180_af.func_187214_a(ARMOR, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(IS_BOOSTING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(BOOST_COOLDOWN, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(BOOSTING_TIMER, (Object)Float.valueOf(0.0f));
        super.func_70088_a();
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("isBoosting", 1)) {
            this.setIsBoosting(compound.func_74767_n("isBoosting"));
        }
        if (compound.func_150297_b("boostCooldown", 5)) {
            this.setBoostCooldown(compound.func_74760_g("boostCooldown"));
        }
        if (compound.func_150297_b("boostingTimer", 5)) {
            this.setBoostingTimer(compound.func_74760_g("boostingTimer"));
        }
        super.func_70037_a(compound);
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("isBoosting", this.getIsBoosting());
        compound.func_74776_a("boostCooldown", this.getBoostCooldown());
        compound.func_74776_a("boostingTimer", this.getBoostingTimer());
        super.func_213281_b(compound);
    }

    public double func_70042_X() {
        return 0.15;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void func_70071_h_() {
        this.setBoostCooldown(this.getBoostCooldown() - 1.0f);
        if (this.getIsBoosting()) {
            this.setBoostingTimer(this.getBoostingTimer() + 1.0f);
            if (this.getBoostingTimer() > 50.0f) {
                this.setIsBoosting(false);
                this.setBoostingTimer(0.0f);
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void respondKeybindSpecial() {
        if (!this.field_70170_p.field_72995_K && this.getBoostCooldown() < 0.0f && this.func_70090_H()) {
            this.setIsBoosting(true);
            this.setBoostCooldown(500.0f);
        }
    }

    @Override
    public float getTravelSpeed() {
        if (this.getIsBoosting() && this.func_70090_H()) {
            return this.waterSpeed * 4.0f;
        }
        if (this.func_70090_H()) {
            return this.waterSpeed;
        }
        return this.landSpeed;
    }

    public void setBoostingTimer(float cooldown) {
        this.field_70180_af.func_187227_b(BOOSTING_TIMER, (Object)Float.valueOf(cooldown));
    }

    public float getBoostingTimer() {
        return ((Float)this.field_70180_af.func_187225_a(BOOSTING_TIMER)).floatValue();
    }

    public void setIsBoosting(boolean isBoosting) {
        this.field_70180_af.func_187227_b(IS_BOOSTING, (Object)isBoosting);
    }

    public boolean getIsBoosting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BOOSTING);
    }

    public void setBoostCooldown(float cooldown) {
        this.field_70180_af.func_187227_b(BOOST_COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public float getBoostCooldown() {
        return ((Float)this.field_70180_af.func_187225_a(BOOST_COOLDOWN)).floatValue();
    }
}

