/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.events;

import com.github.sniffity.panthalassa.server.block.BlockPortalTileEntity;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="panthalassa")
public class PanthalassaEventListener {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Entity vehicle;
        PlayerEntity player = event.getPlayer();
        if (player != null && (vehicle = player.func_184187_bx()) instanceof PanthalassaVehicle) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        Entity vehicle;
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && (player = (PlayerEntity)event.getEntityLiving()) != null && (vehicle = player.func_184187_bx()) instanceof PanthalassaVehicle) {
            event.setCanceled(true);
            vehicle.func_70097_a(event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && EntityPredicates.field_188444_d.test(entity) && entity.field_70170_p.func_234923_W_() == PanthalassaDimension.PANTHALASSA && !(entity instanceof PanthalassaEntity) && (entity.func_184187_bx() == null || !(entity.func_184187_bx() instanceof PanthalassaVehicle))) {
            entity.func_70097_a(DamageSource.field_191291_g, 100.0f);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        BlockState blockstate;
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity && (blockstate = event.getPlacedBlock()).func_177230_c() == PanthalassaBlocks.PORTAL.get()) {
            BlockPos blockPos = event.getPos();
            World world = entity.field_70170_p;
            float minPortalFrameRadius = 6.1f;
            float maxPortalFrameRadius = 7.5f;
            float minRadiusSq = minPortalFrameRadius * minPortalFrameRadius;
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            int x = (int)(-minPortalFrameRadius);
            while ((float)x < minPortalFrameRadius) {
                int z = (int)(-minPortalFrameRadius);
                while ((float)z < minPortalFrameRadius) {
                    int distSq = x * x + z * z;
                    if ((float)distSq <= minRadiusSq) {
                        mutable.func_189533_g((Vector3i)blockPos).func_196234_d(x, 0, z);
                        world.func_180501_a((BlockPos)mutable, ((Block)PanthalassaBlocks.PORTAL.get()).func_176223_P(), 2);
                        TileEntity tileEntity = world.func_175625_s((BlockPos)mutable);
                        if (tileEntity instanceof BlockPortalTileEntity) {
                            ((BlockPortalTileEntity)tileEntity).offsetFromCenter = new BlockPos(x, 0, z);
                        }
                        if (((ServerWorld)world).func_234923_W_() == PanthalassaDimension.PANTHALASSA) {
                            while (mutable.func_189536_c(Direction.UP).func_177956_o() < world.func_234938_ad_() && !world.func_180495_p((BlockPos)mutable).func_203425_a(Blocks.field_150357_h) && mutable.func_177956_o() < blockPos.func_177956_o() + 7) {
                                world.func_180501_a((BlockPos)mutable, Blocks.field_150355_j.func_176223_P(), 2);
                            }
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
    }
}

