/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.WorldSavedData;

public class PanthalassaWorldSavedData
extends WorldSavedData {
    public static final String DATA_KEY = "panthalassa:world_data";
    private List<PlayerTeleportEntry> playerTeleportQueue = new ArrayList<PlayerTeleportEntry>();
    private List<EntityTeleportEntry> entityTeleportQueue = new ArrayList<EntityTeleportEntry>();
    private List<VehicleCompundTeleportEntry> vehicleCompundTeleportQueue = new ArrayList<VehicleCompundTeleportEntry>();

    public PanthalassaWorldSavedData() {
        super(DATA_KEY);
    }

    public static PanthalassaWorldSavedData get(ServerWorld world) {
        return (PanthalassaWorldSavedData)world.func_217481_x().func_215752_a(PanthalassaWorldSavedData::new, DATA_KEY);
    }

    public static void tick(ServerWorld world) {
        ChunkPos entityChunkpos;
        ServerWorld originalWorld;
        ServerWorld targetWorld;
        MinecraftServer server = world.func_73046_m();
        PanthalassaWorldSavedData data = PanthalassaWorldSavedData.get(world);
        List<PlayerTeleportEntry> playerList = data.playerTeleportQueue;
        List<EntityTeleportEntry> entityList = data.entityTeleportQueue;
        List<VehicleCompundTeleportEntry> compoundList = data.vehicleCompundTeleportQueue;
        data.playerTeleportQueue = new ArrayList<PlayerTeleportEntry>();
        data.entityTeleportQueue = new ArrayList<EntityTeleportEntry>();
        data.vehicleCompundTeleportQueue = new ArrayList<VehicleCompundTeleportEntry>();
        for (VehicleCompundTeleportEntry vehicleCompundTeleportEntry : compoundList) {
            Entity vehicle = vehicleCompundTeleportEntry.entity;
            targetWorld = server.func_71218_a(vehicleCompundTeleportEntry.targetWorld);
            originalWorld = server.func_71218_a(vehicleCompundTeleportEntry.originalWorld);
            Vector3d targetVec = vehicleCompundTeleportEntry.targetVec;
            if (targetWorld == null || vehicle == null) continue;
            Entity vehicle2 = vehicle.func_200600_R().func_200721_a((World)targetWorld);
            entityChunkpos = new ChunkPos(vehicle.func_233580_cy_());
            targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, entityChunkpos, 1, (Object)vehicle.func_145782_y());
            originalWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, entityChunkpos, 5, (Object)vehicle.func_233580_cy_());
            assert (vehicle2 != null);
            vehicle2.func_180432_n(vehicle);
            vehicle2.func_174828_a(new BlockPos(targetVec.func_82615_a(), targetVec.func_82617_b(), targetVec.func_82616_c()), vehicle.field_70177_z, vehicle.field_70125_A);
            vehicle2.func_213293_j(0.0, 0.0, 0.0);
            targetWorld.func_217460_e(vehicle2);
            vehicle2.func_242279_ag();
            vehicle.func_70106_y();
            assert (originalWorld != null);
            originalWorld.func_82742_i();
            targetWorld.func_82742_i();
            while (vehicle.func_184188_bt().size() > 0) {
                Entity passenger = (Entity)vehicle.func_184188_bt().get(0);
                passenger.func_184210_p();
                if (passenger instanceof PlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)passenger;
                    ChunkPos playerChunkPos = new ChunkPos(passenger.func_233580_cy_());
                    targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, playerChunkPos, 1, (Object)passenger.func_145782_y());
                    originalWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, entityChunkpos, 5, (Object)vehicle.func_233580_cy_());
                    player.field_70143_R = 0.0f;
                    player.field_70167_r = 0.0;
                    player.func_200619_a(targetWorld, vehicleCompundTeleportEntry.targetVec.func_82615_a(), vehicleCompundTeleportEntry.targetVec.func_82617_b() + 0.2, vehicleCompundTeleportEntry.targetVec.func_82616_c(), vehicleCompundTeleportEntry.yaw, vehicleCompundTeleportEntry.pitch);
                    player.func_184220_m(vehicle2);
                    player.func_242279_ag();
                    continue;
                }
                Entity passenger2 = passenger.func_200600_R().func_200721_a((World)targetWorld);
                ChunkPos entityChunkpos2 = new ChunkPos(passenger.func_233580_cy_());
                targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, entityChunkpos2, 1, (Object)passenger.func_145782_y());
                originalWorld.func_72863_F().func_217228_a(TicketType.field_219493_f, entityChunkpos, 5, (Object)vehicle.func_233580_cy_());
                assert (passenger2 != null);
                passenger2.func_180432_n(passenger);
                passenger2.func_174828_a(new BlockPos(targetVec.func_82615_a(), targetVec.func_82617_b(), targetVec.func_82616_c()), passenger.field_70177_z, passenger.field_70125_A);
                passenger2.func_213293_j(0.0, 0.0, 0.0);
                targetWorld.func_217460_e(passenger2);
                passenger.func_70106_y();
                originalWorld.func_82742_i();
                targetWorld.func_82742_i();
                passenger2.func_184220_m(vehicle2);
                passenger2.func_242279_ag();
            }
        }
        for (PlayerTeleportEntry playerTeleportEntry : playerList) {
            ServerPlayerEntity player = server.func_184103_al().func_177451_a(playerTeleportEntry.playerUUID);
            targetWorld = server.func_71218_a(playerTeleportEntry.targetWorld);
            if (player == null || targetWorld == null) continue;
            ChunkPos playerChunkPos = new ChunkPos(player.func_233580_cy_());
            targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, playerChunkPos, 1, (Object)player.func_145782_y());
            player.field_70143_R = 0.0f;
            player.field_70167_r = 0.0;
            player.func_200619_a(targetWorld, playerTeleportEntry.targetVec.func_82615_a(), playerTeleportEntry.targetVec.func_82617_b() + 0.2, playerTeleportEntry.targetVec.func_82616_c(), playerTeleportEntry.yaw, playerTeleportEntry.pitch);
            player.func_242279_ag();
        }
        for (EntityTeleportEntry entityTeleportEntry : entityList) {
            Entity entity = entityTeleportEntry.entity;
            targetWorld = server.func_71218_a(entityTeleportEntry.targetWorld);
            originalWorld = server.func_71218_a(entityTeleportEntry.originalWorld);
            BlockPos targetBlock = entityTeleportEntry.targetBlock;
            assert (targetWorld != null);
            assert (originalWorld != null);
            Entity entity2 = entity.func_200600_R().func_200721_a((World)targetWorld);
            if (entity2 == null) continue;
            entityChunkpos = new ChunkPos(entity.func_233580_cy_());
            targetWorld.func_72863_F().func_217228_a(TicketType.field_223185_g, entityChunkpos, 1, (Object)entity.func_145782_y());
            entity2.func_180432_n(entity);
            entity2.func_174828_a(targetBlock, entity.field_70177_z, entity.field_70125_A);
            entity2.func_213293_j(0.0, 0.0, 0.0);
            entity2.func_242279_ag();
            targetWorld.func_217460_e(entity2);
            entity.func_70106_y();
            originalWorld.func_82742_i();
            targetWorld.func_82742_i();
        }
    }

    public void addPlayerTP(PlayerEntity player, RegistryKey<World> destination, Vector3d targetVec, float yaw, float pitch) {
        this.playerTeleportQueue.add(new PlayerTeleportEntry(PlayerEntity.func_146094_a((GameProfile)player.func_146103_bH()), destination, targetVec, yaw, pitch));
    }

    public void addEntityTP(Entity entity, RegistryKey<World> destination, RegistryKey<World> origin, Vector3d targetVec, float yaw, float pitch) {
        this.entityTeleportQueue.add(new EntityTeleportEntry(entity, destination, origin, targetVec, yaw, pitch));
    }

    public void addCompoundTP(Entity compoundEntity, RegistryKey<World> destination, RegistryKey<World> origin, Vector3d targetVec, float yaw, float pitch) {
        this.vehicleCompundTeleportQueue.add(new VehicleCompundTeleportEntry(compoundEntity, destination, origin, targetVec, yaw, pitch));
    }

    public void func_76184_a(CompoundNBT nbt) {
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        return null;
    }

    static class VehicleCompundTeleportEntry {
        final Entity entity;
        final RegistryKey<World> targetWorld;
        final RegistryKey<World> originalWorld;
        final BlockPos targetBlock;
        final Vector3d targetVec;
        final float yaw;
        final float pitch;

        public VehicleCompundTeleportEntry(Entity compoundEntity, RegistryKey<World> targetWorld, RegistryKey<World> originalWorld, Vector3d targetVec, float yaw, float pitch) {
            this.entity = compoundEntity;
            this.targetWorld = targetWorld;
            this.originalWorld = originalWorld;
            this.targetVec = targetVec;
            this.targetBlock = new BlockPos(targetVec.func_82615_a(), targetVec.func_82617_b(), targetVec.func_82616_c());
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    static class EntityTeleportEntry {
        final Entity entity;
        final RegistryKey<World> targetWorld;
        final RegistryKey<World> originalWorld;
        final BlockPos targetBlock;
        final float yaw;
        final float pitch;
        final Vector3d targetVec;

        public EntityTeleportEntry(Entity entity, RegistryKey<World> targetWorld, RegistryKey<World> originalWorld, Vector3d targetVec, float yaw, float pitch) {
            this.entity = entity;
            this.targetWorld = targetWorld;
            this.originalWorld = originalWorld;
            this.targetBlock = new BlockPos(targetVec.func_82615_a(), targetVec.func_82617_b(), targetVec.func_82616_c());
            this.targetVec = targetVec;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }

    static class PlayerTeleportEntry {
        final UUID playerUUID;
        final RegistryKey<World> targetWorld;
        final Vector3d targetVec;
        final float yaw;
        final float pitch;

        public PlayerTeleportEntry(UUID playerUUID, RegistryKey<World> targetWorld, Vector3d targetVec, float yaw, float pitch) {
            this.playerUUID = playerUUID;
            this.targetWorld = targetWorld;
            this.targetVec = targetVec;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

