/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.dimension;

import com.github.sniffity.panthalassa.server.world.dimension.SeedBearer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PanthalassaBiomeProvider
extends NetherBiomeProvider {
    public static final MapCodec<NetherBiomeProvider> PACKET_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElseGet(SeedBearer::provideSeed).forGetter(netherProvider -> netherProvider.field_235270_m_), (App)RecordCodecBuilder.create(biomeAttributes -> biomeAttributes.group((App)Biome.Attributes.field_235104_a_.fieldOf("parameters").forGetter(Pair::getFirst), (App)Biome.field_235051_b_.fieldOf("biome").forGetter(Pair::getSecond)).apply((Applicative)biomeAttributes, Pair::of)).listOf().fieldOf("biomes").forGetter(netherProvider -> netherProvider.field_235268_k_), (App)NetherBiomeProvider.Noise.field_242609_a.fieldOf("temperature_noise").forGetter(netherProvider -> netherProvider.field_242597_h), (App)NetherBiomeProvider.Noise.field_242609_a.fieldOf("humidity_noise").forGetter(netherProvider -> netherProvider.field_242598_i), (App)NetherBiomeProvider.Noise.field_242609_a.fieldOf("altitude_noise").forGetter(netherProvider -> netherProvider.field_242599_j), (App)NetherBiomeProvider.Noise.field_242609_a.fieldOf("weirdness_noise").forGetter(netherProvider -> netherProvider.field_242600_k)).apply((Applicative)instance, NetherBiomeProvider::new));
    public static final Codec<NetherBiomeProvider> CODEC = Codec.mapEither((MapCodec)NetherBiomeProvider.DefaultBuilder.field_242624_a, PACKET_CODEC).xmap(either -> (NetherBiomeProvider)either.map(NetherBiomeProvider.DefaultBuilder::func_242635_d, Function.identity()), netherProvider -> netherProvider.func_242605_d().map(Either::left).orElseGet(() -> Either.right((Object)netherProvider))).codec();

    private PanthalassaBiomeProvider(long seed, List<Pair<Biome.Attributes, Supplier<Biome>>> biomeAttributes, Optional<Pair<Registry<Biome>, NetherBiomeProvider.Preset>> netherProviderPreset) {
        super(seed, biomeAttributes, netherProviderPreset);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new PanthalassaBiomeProvider(seed, this.field_235268_k_, this.field_235271_n_);
    }
}

