/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.gen.feature;

import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ColumnConfig;
import net.minecraft.world.gen.feature.Feature;

public class FeatureAncientColumn
extends Feature<ColumnConfig> {
    public FeatureAncientColumn(Codec<ColumnConfig> p_i231925_1_) {
        super(p_i231925_1_);
    }

    public boolean place(ISeedReader p_241855_1_, ChunkGenerator p_241855_2_, Random p_241855_3_, BlockPos p_241855_4_, ColumnConfig p_241855_5_) {
        double r = Math.floor(Math.random() * 81.0 + 20.0);
        BlockPos blockpos1 = new BlockPos((double)p_241855_4_.func_177958_n(), r, (double)p_241855_4_.func_177952_p());
        int i = p_241855_2_.func_230356_f_();
        if (!FeatureAncientColumn.canPlaceAt((IWorld)p_241855_1_, i, blockpos1.func_239590_i_())) {
            return false;
        }
        int j = p_241855_5_.func_242795_b().func_242259_a(p_241855_3_);
        boolean flag = p_241855_3_.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos : BlockPos.func_239585_a_((Random)p_241855_3_, (int)l, (int)(blockpos1.func_177958_n() - k), (int)blockpos1.func_177956_o(), (int)(blockpos1.func_177952_p() - k), (int)(blockpos1.func_177958_n() + k), (int)blockpos1.func_177956_o(), (int)(blockpos1.func_177952_p() + k))) {
            int i1 = j - blockpos.func_218139_n((Vector3i)blockpos1);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((IWorld)p_241855_1_, i, blockpos, i1, p_241855_5_.func_242794_am_().func_242259_a(p_241855_3_));
        }
        return flag1;
    }

    private boolean placeColumn(IWorld p_236248_1_, int p_236248_2_, BlockPos p_236248_3_, int p_236248_4_, int p_236248_5_) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.func_191531_b((int)(p_236248_3_.func_177958_n() - p_236248_5_), (int)p_236248_3_.func_177956_o(), (int)(p_236248_3_.func_177952_p() - p_236248_5_), (int)(p_236248_3_.func_177958_n() + p_236248_5_), (int)p_236248_3_.func_177956_o(), (int)(p_236248_3_.func_177952_p() + p_236248_5_))) {
            int i = blockpos.func_218139_n((Vector3i)p_236248_3_);
            BlockPos blockpos1 = FeatureAncientColumn.isWater(p_236248_1_, p_236248_2_, blockpos) ? FeatureAncientColumn.findSurface(p_236248_1_, p_236248_2_, blockpos.func_239590_i_(), i) : FeatureAncientColumn.findWater(p_236248_1_, blockpos.func_239590_i_(), i);
            if (blockpos1 == null) continue;
            BlockPos.Mutable blockpos$mutable = blockpos1.func_239590_i_();
            for (int j = p_236248_4_ - i / 2; j >= 0; --j) {
                if (FeatureAncientColumn.isWater(p_236248_1_, p_236248_2_, (BlockPos)blockpos$mutable)) {
                    this.func_230367_a_((IWorldWriter)p_236248_1_, (BlockPos)blockpos$mutable, Blocks.field_235337_cO_.func_176223_P());
                    blockpos$mutable.func_189536_c(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!p_236248_1_.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(Blocks.field_235337_cO_)) continue block0;
                blockpos$mutable.func_189536_c(Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(IWorld p_236246_0_, int p_236246_1_, BlockPos.Mutable p_236246_2_, int p_236246_3_) {
        while (p_236246_2_.func_177956_o() > 1 && p_236246_3_ > 0) {
            --p_236246_3_;
            if (FeatureAncientColumn.canPlaceAt(p_236246_0_, p_236246_1_, p_236246_2_)) {
                return p_236246_2_;
            }
            p_236246_2_.func_189536_c(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(IWorld p_242762_0_, int p_242762_1_, BlockPos.Mutable p_242762_2_) {
        if (!FeatureAncientColumn.isWater(p_242762_0_, p_242762_1_, (BlockPos)p_242762_2_)) {
            return false;
        }
        BlockState blockState = p_242762_0_.func_180495_p((BlockPos)p_242762_2_.func_189536_c(Direction.DOWN));
        p_242762_2_.func_189536_c(Direction.UP);
        return !blockState.func_203425_a((Block)PanthalassaBlocks.PANTHALASSA_WATER.get());
    }

    @Nullable
    private static BlockPos findWater(IWorld p_236249_0_, BlockPos.Mutable p_236249_1_, int p_236249_2_) {
        while (p_236249_1_.func_177956_o() < p_236249_0_.func_217301_I() && p_236249_2_ > 0) {
            --p_236249_2_;
            BlockState blockstate = p_236249_0_.func_180495_p((BlockPos)p_236249_1_);
            if (blockstate.func_203425_a((Block)PanthalassaBlocks.PANTHALASSA_WATER.get())) {
                return p_236249_1_;
            }
            p_236249_1_.func_189536_c(Direction.UP);
        }
        return null;
    }

    private static boolean isWater(IWorld p_236247_0_, int p_236247_1_, BlockPos p_236247_2_) {
        BlockState blockstate = p_236247_0_.func_180495_p(p_236247_2_);
        return blockstate.func_203425_a((Block)PanthalassaBlocks.PANTHALASSA_WATER.get());
    }
}

