/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.teleporter;

import com.github.sniffity.panthalassa.Panthalassa;
import com.github.sniffity.panthalassa.server.block.BlockPortal;
import com.github.sniffity.panthalassa.server.block.BlockPortalTileEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class PanthalassaTeleporter
implements ITeleporter {
    protected final ServerWorld world;

    public PanthalassaTeleporter(ServerWorld worldIn) {
        this.world = worldIn;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, BlockPos portalBlockPos) {
        Optional<TeleportationRepositioner.Result> result = this.makePortalFromPos(destWorld, entity.field_70170_p, portalBlockPos);
        if (result.isPresent()) {
            BlockPos startPos = result.get().field_243679_a;
            if (destWorld.func_234923_W_() == PanthalassaDimension.PANTHALASSA) {
                return new PortalInfo(new Vector3d((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p()), entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
            }
            destWorld.func_217349_x(new BlockPos(startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p()));
            return new PortalInfo(new Vector3d((double)startPos.func_177958_n(), (double)startPos.func_177956_o(), (double)startPos.func_177952_p()), entity.func_213322_ci(), entity.field_70177_z, entity.field_70125_A);
        }
        return null;
    }

    private boolean checkRegionForPlacement(BlockPos potentialPos, World world) {
        BlockPos.Mutable check = new BlockPos.Mutable();
        for (int x = -8; x < 9; ++x) {
            for (int y = -1; y > -5; --y) {
                for (int z = -8; z < 9; ++z) {
                    check.func_181079_c(potentialPos.func_177958_n() + x, potentialPos.func_177956_o() + y, potentialPos.func_177952_p() + z);
                    if (world.func_204610_c((BlockPos)check).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<TeleportationRepositioner.Result> makePortalFromPos(ServerWorld destWorld, World originalWorld, @Nonnull BlockPos originalPosition) {
        BlockPortalTileEntity centerTE;
        if (destWorld.func_234923_W_() == World.field_234918_g_) {
            Panthalassa.LOGGER.warn("Corresponding Overworld Portal not found!");
            Panthalassa.LOGGER.warn("Teleporting to spawn");
            BlockPos spawnPoint = new BlockPos(destWorld.func_241135_u_().func_177958_n(), destWorld.func_241135_u_().func_177956_o(), destWorld.func_241135_u_().func_177952_p());
            return Optional.of(new TeleportationRepositioner.Result(spawnPoint.func_185334_h(), 1, 1));
        }
        BlockPos destPosition = new BlockPos(originalPosition.func_177958_n(), destWorld.func_234938_ad_() - 5, originalPosition.func_177952_p());
        destPosition = this.getValidPortalLocation(destWorld, originalPosition, destPosition);
        BlockPortal.matchShapeSize portalMatch = new BlockPortal.matchShapeSize((IWorld)destWorld, destPosition, true);
        BlockPortalTileEntity tempTE = this.getPortalTE((IWorld)originalWorld, originalPosition);
        if (tempTE != null && (centerTE = this.getPortalTE((IWorld)originalWorld, originalPosition.func_177973_b((Vector3i)tempTE.offsetFromCenter))) != null) {
            portalMatch.linkPortalCenters((IWorld)originalWorld, centerTE.func_174877_v());
        }
        return Optional.of(new TeleportationRepositioner.Result(destPosition.func_185334_h(), 15, 1));
    }

    private BlockPos getValidPortalLocation(ServerWorld destWorld, BlockPos originalPosition, BlockPos destPosition) {
        int newSpotOffset = 16;
        int radiusCheckLimit = 500;
        BlockPos.Mutable currentPosition = new BlockPos.Mutable().func_189533_g((Vector3i)destPosition);
        for (int currentRadius = 0; currentRadius <= radiusCheckLimit; currentRadius += newSpotOffset) {
            for (int x = -currentRadius; x <= currentRadius; x += newSpotOffset) {
                for (int z = -currentRadius; z <= currentRadius; z += newSpotOffset) {
                    if (Math.abs(x) != currentRadius) continue;
                    currentPosition.func_189533_g((Vector3i)destPosition).func_196234_d(x, 0, z);
                    while (currentPosition.func_177956_o() > -1) {
                        currentPosition.func_189536_c(Direction.DOWN);
                        if (!destWorld.func_204610_c((BlockPos)currentPosition).func_206884_a((ITag)FluidTags.field_206959_a) || !this.checkRegionForPlacement((BlockPos)currentPosition, (World)destWorld)) continue;
                        return currentPosition.func_185334_h();
                    }
                }
            }
        }
        Panthalassa.LOGGER.error("Panthalassa: Unable to find valid portal location after searching {} radius. Force spawning portal regardless of conditions now.", (Object)radiusCheckLimit);
        return new BlockPos(originalPosition.func_177958_n(), 64, originalPosition.func_177952_p());
    }

    private BlockPortalTileEntity getPortalTE(IWorld world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BlockPortalTileEntity) {
            return (BlockPortalTileEntity)tileEntity;
        }
        Panthalassa.LOGGER.error("Panthalassa: Failed to grab portal block entity from entity position for connecting the two portals");
        return null;
    }
}

