/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa;

import com.github.sniffity.panthalassa.config.PanthalassaClientConfig;
import com.github.sniffity.panthalassa.config.PanthalassaCommonConfig;
import com.github.sniffity.panthalassa.server.entity.creature.EntityArchelon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityBasilosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityCoelacanth;
import com.github.sniffity.panthalassa.server.entity.creature.EntityDunkleosteus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityGiantOrthocone;
import com.github.sniffity.panthalassa.server.entity.creature.EntityKronosaurus;
import com.github.sniffity.panthalassa.server.entity.creature.EntityLeedsichthys;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMegalodon;
import com.github.sniffity.panthalassa.server.entity.creature.EntityMosasaurus;
import com.github.sniffity.panthalassa.server.network.PanthalassaPacketHandler;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlockEntities;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaConfiguredStructures;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import com.github.sniffity.panthalassa.server.registry.PanthalassaFeatures;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItemGroup;
import com.github.sniffity.panthalassa.server.registry.PanthalassaItems;
import com.github.sniffity.panthalassa.server.registry.PanthalassaPOI;
import com.github.sniffity.panthalassa.server.registry.PanthalassaSounds;
import com.github.sniffity.panthalassa.server.registry.PanthalassaStructures;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="panthalassa")
@Mod.EventBusSubscriber(modid="panthalassa", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Panthalassa {
    public static final String MODID = "panthalassa";
    public static final Logger LOGGER = LogManager.getLogger();

    public Panthalassa() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, PanthalassaDimension::worldTick);
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        modBus.addListener(this::setup);
        modBus.addListener(this::registerEntityAttributes);
        PanthalassaBlockEntities.BLOCK_ENTITY_TYPES.register(modBus);
        PanthalassaEntityTypes.ENTITY_TYPES.register(modBus);
        PanthalassaItems.ITEMS.register(modBus);
        PanthalassaBlocks.BLOCKS.register(modBus);
        PanthalassaStructures.STRUCTURES.register(modBus);
        PanthalassaSounds.SOUND_EVENTS.register(modBus);
        PanthalassaPOI.POI.register(modBus);
        PanthalassaFeatures.FEATURES.register(modBus);
        forgeBus.register(PanthalassaDimension.PANTHALASSA);
        forgeBus.register(PanthalassaDimension.PANTHALASSA_TYPE);
        GeckoLib.initialize();
        forgeBus.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PanthalassaClientConfig.GENERAL_SPEC, "panthalassa-client-config.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PanthalassaCommonConfig.GENERAL_SPEC, "panthalassa-common-config.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        PanthalassaPacketHandler.register();
        event.enqueueWork(() -> {
            PanthalassaStructures.setupStructures();
            PanthalassaConfiguredStructures.registerConfiguredStructures();
            PanthalassaEntityTypes.spawnPlacements();
            PanthalassaDimension.registerDimensionAccessories();
        });
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)PanthalassaEntityTypes.KRONOSAURUS.get(), EntityKronosaurus.kronosaurusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.MEGALODON.get(), EntityMegalodon.megalodonAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.ARCHELON.get(), EntityArchelon.archelonAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.MOSASAURUS.get(), EntityMosasaurus.mosasaurusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.COELACANTH.get(), EntityCoelacanth.coelacanthAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.DUNKLEOSTEUS.get(), EntityDunkleosteus.dunkleosteusAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.LEEDSICHTHYS.get(), EntityLeedsichthys.leedsichthysAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.GIANT_ORTHOCONE.get(), EntityGiantOrthocone.giantOrthoconeAttributes().m_22265_());
        event.put((EntityType)PanthalassaEntityTypes.BASILOSAURUS.get(), EntityBasilosaurus.basilosaurusAttributes().m_22265_());
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap PanthalassaStructureMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                Biome.BiomeCategory biomeCategory = ((Biome)biomeEntry.getValue()).m_47567_();
                if (biomeCategory != Biome.BiomeCategory.OCEAN) continue;
                Panthalassa.associateBiomeToConfiguredStructure(PanthalassaStructureMultiMap, PanthalassaConfiguredStructures.CONFIGURED_PANTHALASSA_LABORATORY, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !PanthalassaStructureMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            PanthalassaStructureMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)PanthalassaStructures.PANTHALASSA_LABORATORY.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)PanthalassaStructures.PANTHALASSA_LABORATORY.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> PanthalassaStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        PanthalassaStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = PanthalassaStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.debug("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        PanthalassaBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> event.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem(block, new Item.Properties().m_41491_(PanthalassaItemGroup.GROUP)).setRegistryName(block.getRegistryName()))));
    }
}

