/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client.events;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleAGII;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleMRSV;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CameraSetupEvent {
    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = Minecraft.m_91087_();
        Entity vehicle = mc.f_91074_.m_20202_();
        if (!(vehicle instanceof PanthalassaVehicle)) {
            return;
        }
        CameraType view = mc.f_91066_.m_92176_();
        float yCamera = vehicle.f_19853_.m_8055_(new BlockPos(vehicle.m_20182_()).m_7494_()).m_60815_() ? -4.0f : 1.0f;
        if (view == CameraType.THIRD_PERSON_BACK) {
            if (vehicle instanceof VehicleMRSV) {
                event.getCamera().m_90568_(-CameraSetupEvent.calcCameraDistance(8.0, vehicle), (double)yCamera, 0.0);
            }
            if (vehicle instanceof VehicleAGII) {
                event.getCamera().m_90568_(-CameraSetupEvent.calcCameraDistance(12.0, vehicle), (double)yCamera, 0.0);
            }
        } else {
            if (vehicle instanceof VehicleMRSV) {
                event.getCamera().m_90568_(-CameraSetupEvent.calcCameraDistance(-1.5, vehicle), (double)yCamera, 0.0);
            }
            if (vehicle instanceof VehicleAGII) {
                event.getCamera().m_90568_(-CameraSetupEvent.calcCameraDistance(-2.0, vehicle), (double)yCamera, 0.0);
            }
        }
    }

    public static double calcCameraDistance(double startingDistance, Entity vehicle) {
        Camera info = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 position = info.m_90583_().m_82520_(0.0, 1.0, 0.0);
        Vector3f view = info.m_90596_();
        for (int i = 0; i < 8; ++i) {
            double d0;
            Vec3 vector3d1;
            BlockHitResult raytraceresult;
            float f = (i & 1) * 2 - 1;
            float f1 = (i >> 1 & 1) * 2 - 1;
            float f2 = (i >> 2 & 1) * 2 - 1;
            Vec3 vector3d = position.m_82520_((double)(f *= 0.1f), (double)(f1 *= 0.1f), (double)(f2 *= 0.1f));
            if ((raytraceresult = vehicle.f_19853_.m_45547_(new ClipContext(vector3d, vector3d1 = new Vec3(position.f_82479_ - (double)view.m_122239_() * startingDistance + (double)f + (double)f2, position.f_82480_ - (double)view.m_122260_() * startingDistance + (double)f1, position.f_82481_ - (double)view.m_122269_() * startingDistance + (double)f2), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, vehicle))).m_6662_() == HitResult.Type.MISS || !((d0 = raytraceresult.m_82450_().m_82554_(position)) < startingDistance)) continue;
            startingDistance = d0 < 0.2 ? d0 - 3.0 : d0 - 1.5;
        }
        return startingDistance;
    }
}

