/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client.events;

import com.github.sniffity.panthalassa.config.PanthalassaClientConfig;
import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleAGII;
import com.github.sniffity.panthalassa.server.entity.vehicle.VehicleMRSV;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderTickEvent {
    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        String vehicleText;
        if (!((Boolean)PanthalassaClientConfig.vehicleOverlayEnabled.get()).booleanValue()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft game = Minecraft.m_91087_();
        if (!game.m_91302_() || game.f_91066_.f_92062_) {
            return;
        }
        LocalPlayer player = game.f_91074_;
        if (player == null) {
            return;
        }
        Entity playerVehicle = player.m_20202_();
        if (!(playerVehicle instanceof PanthalassaVehicle)) {
            return;
        }
        PoseStack matrixStack = new PoseStack();
        PanthalassaVehicle vehicle = (PanthalassaVehicle)playerVehicle;
        if (vehicle instanceof VehicleMRSV) {
            vehicleText = "MANTA RAY SUBMERSIBLE VEHICLE";
            float boostCooldown = ((VehicleMRSV)vehicle).getBoostCooldown();
            if (boostCooldown < 0.0f) {
                boostCooldownText = "BOOST READY";
                game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Boost Cooldown: " + ChatFormatting.GREEN + boostCooldownText, 10.0f, 85.0f, Color.WHITE.getRGB());
            } else {
                boostCooldownText = new DecimalFormat("00").format(boostCooldown);
                game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Boost Cooldown: " + ChatFormatting.YELLOW + boostCooldownText, 10.0f, 85.0f, Color.WHITE.getRGB());
            }
        }
        if (vehicle instanceof VehicleAGII) {
            vehicleText = "ABYSS GLIDER II SUBMERSIBLE VEHICLE";
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.BOLD + vehicleText, 135.0f, 10.0f, Color.WHITE.getRGB());
        }
        if (vehicle.getMaxHealth() != 0.0f) {
            String vehicleIntegrity = new DecimalFormat("00").format(vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f);
            if (vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f > 50.0f) {
                game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Vehicle Integrity: " + ChatFormatting.GREEN + vehicleIntegrity, 10.0f, 25.0f, Color.WHITE.getRGB());
            } else if (vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f > 20.0f) {
                game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Vehicle Integrity: " + ChatFormatting.YELLOW + vehicleIntegrity, 10.0f, 25.0f, Color.WHITE.getRGB());
            } else if (vehicle.getHealth() / vehicle.getMaxHealth() * 100.0f > 0.0f) {
                game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Vehicle Integrity: " + ChatFormatting.RED + vehicleIntegrity, 10.0f, 25.0f, Color.WHITE.getRGB());
            } else {
                game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Vehicle Integrity: " + ChatFormatting.DARK_PURPLE + "processing...", 10.0f, 25.0f, Color.WHITE.getRGB());
            }
        }
        String depth = vehicle.f_19853_.m_46472_() == PanthalassaDimension.PANTHALASSA ? new DecimalFormat("0").format(vehicle.m_142538_().m_123342_() - 20100) : new DecimalFormat("0").format(vehicle.m_142538_().m_123342_());
        game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Depth: " + ChatFormatting.YELLOW + depth, 10.0f, 35.0f, Color.WHITE.getRGB());
        double x = vehicle.getEntryX();
        double z = vehicle.getEntryZ();
        String entryXText = new DecimalFormat("0").format(x);
        String entryZText = new DecimalFormat("0").format(z);
        if (x != 0.0) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Entry X: " + ChatFormatting.YELLOW + entryXText, 10.0f, 55.0f, Color.WHITE.getRGB());
        } else {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Entry X: " + ChatFormatting.YELLOW + "???", 10.0f, 55.0f, Color.WHITE.getRGB());
        }
        if (z != 0.0) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Entry Z: " + ChatFormatting.YELLOW + entryZText, 10.0f, 65.0f, Color.WHITE.getRGB());
        } else {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Entry Z: " + ChatFormatting.YELLOW + "???", 10.0f, 65.0f, Color.WHITE.getRGB());
        }
        double nlfDistance = vehicle.getNLFDistance();
        String nlfDistanceText = new DecimalFormat("0").format(nlfDistance);
        if (nlfDistance > 10.0) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "NLF Distance: " + ChatFormatting.GREEN + nlfDistanceText, 10.0f, 220.0f, Color.WHITE.getRGB());
        } else if (nlfDistance > 5.0) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "NLF Distance: " + ChatFormatting.YELLOW + nlfDistanceText, 10.0f, 220.0f, Color.WHITE.getRGB());
        } else if (nlfDistance >= 0.0) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "NLF Distance: " + ChatFormatting.RED + nlfDistanceText, 10.0f, 220.0f, Color.WHITE.getRGB());
        } else {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "NLF Distance: " + ChatFormatting.DARK_PURPLE + "processing...", 10.0f, 220.0f, Color.WHITE.getRGB());
        }
        int floorDistance = vehicle.getFloorDistance();
        String floorDistanceText = new DecimalFormat("0").format(floorDistance);
        if (floorDistance > 20) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Floor Distance: " + ChatFormatting.GREEN + floorDistanceText, 10.0f, 230.0f, Color.WHITE.getRGB());
        } else if (floorDistance > 10) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Floor Distance: " + ChatFormatting.YELLOW + floorDistanceText, 10.0f, 230.0f, Color.WHITE.getRGB());
        } else if (floorDistance >= 0) {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Floor Distance: " + ChatFormatting.RED + floorDistanceText, 10.0f, 230.0f, Color.WHITE.getRGB());
        } else {
            game.f_91062_.m_92750_(matrixStack, ChatFormatting.AQUA + "Floor Distance: " + ChatFormatting.DARK_PURPLE + "processing...", 10.0f, 230.0f, Color.WHITE.getRGB());
        }
    }
}

