/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.AnimationUtils;

public class PanthalassaVehicleRenderer<T extends Entity>
extends EntityRenderer<T>
implements IGeoRenderer<T> {
    private final AnimatedGeoModel<T> modelProvider;

    protected PanthalassaVehicleRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<T> modelProvider) {
        super(renderManager);
        this.modelProvider = modelProvider;
    }

    public void m_7392_(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(entityIn));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-((Entity)entityIn).f_19857_ + 180.0f));
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-((Entity)entityIn).f_19858_));
        Minecraft.m_91087_().f_90987_.m_174784_(this.m_5478_(entityIn));
        Color renderColor = this.getRenderColor(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn);
        RenderType renderType = this.getRenderType(entityIn, partialTicks, matrixStackIn, bufferIn, null, packedLightIn, this.m_5478_(entityIn));
        this.render(model, entityIn, partialTicks, renderType, matrixStackIn, bufferIn, null, packedLightIn, PanthalassaVehicleRenderer.getPackedOverlay(entityIn, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        float lastLimbDistance = 0.0f;
        float limbSwing = 0.0f;
        EntityModelData entityModelData = new EntityModelData();
        AnimationEvent predicate = new AnimationEvent((IAnimatable)entityIn, limbSwing, lastLimbDistance, partialTicks, !(lastLimbDistance > -0.15f) || !(lastLimbDistance < 0.15f), Collections.singletonList(entityModelData));
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(entityIn, this.getUniqueID(entityIn), predicate);
        }
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public static int getPackedOverlay(Entity livingEntityIn, float uIn) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)uIn), (int)OverlayTexture.m_118096_((boolean)false));
    }

    public GeoModelProvider<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    public ResourceLocation m_5478_(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    protected int m_6086_(T entityIn, BlockPos partialTicks) {
        return 0;
    }

    static {
        AnimationController.addModelFetcher(object -> object instanceof Entity ? (IAnimatableModel)AnimationUtils.getGeoModelForEntity((Entity)((Entity)object)) : null);
    }
}

