/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class PanthalassaClientConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.DoubleValue archelonSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue coealacanthSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue dunkleosteusSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue kronosaurusSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue leedsichthysSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue megalodonSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue mosasaurusSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue giantOrthoconeSizeMultiplier;
    public static ForgeConfigSpec.DoubleValue basilosaurusSizeMultiplier;
    public static ForgeConfigSpec.BooleanValue vehicleOverlayEnabled;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Panthalassa Client Config - Values changed in this document will only affect the client.");
        builder.push("Creature Size Multiplier");
        builder.comment("This value can be used to scale creature size upwards.");
        builder.comment("Setting a value of 3, for instance, will make all corresponding creatures three times larger.");
        builder.comment("Word of Warning: Larger creatures will possess less smooth animations and may cause visual clipping issues.");
        archelonSizeMultiplier = builder.defineInRange("archelon_size_multiplier", 1.0, 0.5, 3.0);
        coealacanthSizeMultiplier = builder.defineInRange("coealacanth_size_multiplier", 1.0, 0.5, 3.0);
        dunkleosteusSizeMultiplier = builder.defineInRange("dunkleosteus_size_multiplier", 1.0, 0.5, 3.0);
        kronosaurusSizeMultiplier = builder.defineInRange("kronosaurus_size_multiplier", 1.0, 0.5, 3.0);
        leedsichthysSizeMultiplier = builder.defineInRange("leedsichthys_size_multiplier", 1.0, 0.5, 3.0);
        megalodonSizeMultiplier = builder.defineInRange("megalodon_size_multiplier", 1.0, 0.5, 3.0);
        mosasaurusSizeMultiplier = builder.defineInRange("mosasaurus_size_multiplier", 1.0, 0.5, 3.0);
        giantOrthoconeSizeMultiplier = builder.defineInRange("giant_orthocone_size_multiplier", 1.0, 0.5, 3.0);
        basilosaurusSizeMultiplier = builder.defineInRange("basilosaurus_size_multiplier", 1.0, 0.5, 3.0);
        builder.pop();
        builder.push("Vehicle Overlay");
        builder.comment("This will determine whether the vehicle overlays are enabled or not.");
        vehicleOverlayEnabled = builder.define("vehicle-overlay-enabled", true);
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        PanthalassaClientConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

