/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.ICrushable;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaCrushAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaEscapeGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaMeleeAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaRandomSwimmingGoal;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityGiantOrthocone
extends PanthalassaEntity
implements IAnimatable,
Enemy,
ICrushable {
    public static final int BLOCKED_DISTANCE = 3;
    protected static final EntityDataAccessor<Float> CRUSH_COOLDOWN = SynchedEntityData.m_135353_(EntityGiantOrthocone.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> CRUSHING_STATE = SynchedEntityData.m_135353_(EntityGiantOrthocone.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CRUSHING = SynchedEntityData.m_135353_(EntityGiantOrthocone.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public EntityGiantOrthocone(EntityType<? extends PanthalassaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.canBreatheOutsideWater = false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRUSH_COOLDOWN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CRUSHING_STATE, (Object)false);
        this.f_19804_.m_135372_(CRUSHING, (Object)false);
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getCrushingState()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_orthocone.grabbing", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getAttackingState() && !this.f_20890_ && !((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_orthocone.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20184_().m_82553_() > 0.0 && this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_orthocone.swimming", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20096_() && !this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_orthocone.beached", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, CompoundTag compound) {
        return super.m_6518_(world, difficulty, reason, livingdata, compound);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.setCrushCooldown(this.getCrushCooldown() - 1.0f);
    }

    public static AttributeSupplier.Builder giantOrthoconeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)1.3f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanthalassaCrushAttackGoal(this, 2.0));
        this.f_21345_.m_25352_(1, (Goal)new PanthalassaMeleeAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new PanthalassaEscapeGoal(this, 1.3f));
        this.f_21345_.m_25352_(3, (Goal)new PanthalassaRandomSwimmingGoal(this, 0.7f, 10, 3));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 1, true, false, entity -> entity.m_20202_() != null));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> entity instanceof Player && this.f_19853_.m_46791_() != Difficulty.PEACEFUL && (entity.m_20069_() || entity.f_19853_.m_6425_(entity.m_142538_().m_7495_()).m_76153_((Tag)FluidTags.f_13131_))));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> !(entity instanceof Player) && !(entity instanceof EntityGiantOrthocone) && (entity.m_20069_() || entity.f_19853_.m_6425_(entity.m_142538_().m_7495_()).m_76153_((Tag)FluidTags.f_13131_))));
    }

    @Override
    public void setCrushCooldown(float crushCooldown) {
        this.f_19804_.m_135381_(CRUSH_COOLDOWN, (Object)Float.valueOf(crushCooldown));
    }

    @Override
    public float getCrushCooldown() {
        return ((Float)this.f_19804_.m_135370_(CRUSH_COOLDOWN)).floatValue();
    }

    @Override
    public void setCrushingState(boolean isCrushing) {
        this.f_19804_.m_135381_(CRUSHING_STATE, (Object)isCrushing);
    }

    @Override
    public boolean getCrushingState() {
        return (Boolean)this.f_19804_.m_135370_(CRUSHING_STATE);
    }

    @Override
    public void setCrushing(boolean isCrushing) {
        this.f_19804_.m_135381_(CRUSHING, (Object)isCrushing);
    }

    @Override
    public boolean getCrushing() {
        return (Boolean)this.f_19804_.m_135370_(CRUSHING);
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = 1.0f;
            float f1 = (float)((!this.m_6084_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            float f2 = 0.0f;
            Vec3 vector3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.f_19857_ * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1 + (double)f2, this.m_20189_() + vector3d.f_82481_);
        }
    }
}

