/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature;

import com.github.sniffity.panthalassa.server.entity.creature.EntityArchelon;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.IBreachable;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaBreachAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaEscapeGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaMeleeAttackGoal;
import com.github.sniffity.panthalassa.server.entity.creature.ai.PanthalassaRandomSwimmingGoal;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class EntityMegalodon
extends PanthalassaEntity
implements IAnimatable,
Enemy,
IBreachable {
    public static final int BLOCKED_DISTANCE = 3;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected static final EntityDataAccessor<Boolean> BREACH_STATE = SynchedEntityData.m_135353_(EntityMegalodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_BREACHING = SynchedEntityData.m_135353_(EntityMegalodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> BREACH_COOLDOWN = SynchedEntityData.m_135353_(EntityMegalodon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> TEXTURE_VARIANT = SynchedEntityData.m_135353_(EntityMegalodon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityMegalodon(EntityType<? extends PanthalassaEntity> type, Level worldIn) {
        super(type, worldIn);
        this.adjustment = 0.25f;
        this.canBreatheOutsideWater = false;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getBreachState()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.megalodon.breach", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.getAttackingState() && !this.f_20890_ && !((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.megalodon.attack", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.m_20096_() && !this.m_20069_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.megalodon.beached", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(BREACH_STATE, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(IS_BREACHING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BREACH_COOLDOWN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TEXTURE_VARIANT, (Object)0);
        super.m_8097_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.setBreachCooldown(this.getBreachCooldown() - 1.0f);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public double m_6048_() {
        return 0.2;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, CompoundTag compound) {
        int textureVariant = (int)(Math.random() * 3.0);
        this.setTextureVariant(textureVariant);
        return super.m_6518_(world, difficulty, reason, livingdata, compound);
    }

    public static AttributeSupplier.Builder megalodonAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 175.0).m_22268_(Attributes.f_22279_, (double)1.3f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanthalassaBreachAttackGoal(this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new PanthalassaMeleeAttackGoal(this, 2.0, false));
        this.f_21345_.m_25352_(3, (Goal)new PanthalassaEscapeGoal(this, 1.3f));
        this.f_21345_.m_25352_(4, (Goal)new PanthalassaRandomSwimmingGoal(this, 0.9f, 10, 3));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 1, true, false, entity -> entity.m_20202_() != null));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> entity instanceof Player && this.f_19853_.m_46791_() != Difficulty.PEACEFUL));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> !(entity instanceof Player) && !(entity instanceof EntityMegalodon) && !(entity instanceof EntityArchelon)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 40, true, false, entity -> entity instanceof EntityArchelon));
        super.m_8099_();
    }

    @Override
    public void setBreachState(boolean breaching) {
        this.f_19804_.m_135381_(BREACH_STATE, (Object)breaching);
    }

    @Override
    public boolean getBreachState() {
        return (Boolean)this.f_19804_.m_135370_(BREACH_STATE);
    }

    @Override
    public void setBreaching(boolean breaching) {
        this.f_19804_.m_135381_(IS_BREACHING, (Object)breaching);
    }

    @Override
    public boolean getBreaching() {
        return (Boolean)this.f_19804_.m_135370_(IS_BREACHING);
    }

    @Override
    public void setBreachCooldown(float breachCooldown) {
        this.f_19804_.m_135381_(BREACH_COOLDOWN, (Object)Float.valueOf(breachCooldown));
    }

    @Override
    public float getBreachCooldown() {
        return ((Float)this.f_19804_.m_135370_(BREACH_COOLDOWN)).floatValue();
    }

    public void setTextureVariant(int textureVariant) {
        this.f_19804_.m_135381_(TEXTURE_VARIANT, (Object)textureVariant);
    }

    public int getTextureVariant() {
        return (Integer)this.f_19804_.m_135370_(TEXTURE_VARIANT);
    }
}

