/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.IBreachable;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;

public class PanthalassaBreachAttackGoal
extends Goal {
    protected final IBreachable panthalassaBreachableEntity;
    protected final PanthalassaEntity attacker;
    private final double speedTowardsTarget;
    private boolean step1Done;
    private boolean step2Done;
    private boolean step3Done;
    private boolean step4Done;
    private double jumpStart;
    private double step1Ticks;
    private double step2Ticks;
    private double step3Ticks;
    private double step4Ticks;
    private BlockPos strikePos;

    public PanthalassaBreachAttackGoal(IBreachable creature, double speedIn) {
        this.panthalassaBreachableEntity = creature;
        this.attacker = (PanthalassaEntity)((Object)creature);
        this.speedTowardsTarget = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.attacker.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (!this.attacker.f_19853_.m_8055_(new BlockPos((Vec3i)target.m_142538_().m_7495_())).m_60647_((BlockGetter)this.attacker.f_19853_, new BlockPos((Vec3i)target.m_142538_().m_7495_()), PathComputationType.WATER)) {
            return false;
        }
        if (!this.attacker.m_20069_() && !this.attacker.f_19853_.m_8055_(new BlockPos(this.attacker.m_20182_()).m_7495_()).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        if (this.panthalassaBreachableEntity.getBreachCooldown() > 0.0f) {
            return false;
        }
        if (this.attacker.f_19853_.m_46472_() == PanthalassaDimension.PANTHALASSA) {
            return false;
        }
        BlockPos targetAbove = new BlockPos(target.m_20185_(), target.m_20186_() + 3.0, target.m_20189_());
        if (!this.attacker.f_19853_.m_8055_(targetAbove).m_60713_(Blocks.f_50016_)) {
            return false;
        }
        return !this.attacker.isLandNavigator;
    }

    public boolean m_8045_() {
        LivingEntity target = this.attacker.m_5448_();
        if (!(this.step3Done || target != null && target.m_6084_())) {
            return false;
        }
        if (!this.step1Done && !this.attacker.m_20069_()) {
            return false;
        }
        if (target != null) {
            if (this.attacker.m_20270_((Entity)target) > 30.0f) {
                return false;
            }
            if (!this.step1Done && !this.attacker.f_19853_.m_8055_(new BlockPos((Vec3i)target.m_142538_().m_6625_(10))).m_60647_((BlockGetter)this.attacker.f_19853_, new BlockPos((Vec3i)target.m_142538_().m_7495_()), PathComputationType.WATER)) {
                return false;
            }
            if (this.step1Done && !this.step2Done && !this.attacker.f_19853_.m_8055_(new BlockPos((Vec3i)target.m_142538_().m_6625_(1))).m_60647_((BlockGetter)this.attacker.f_19853_, new BlockPos((Vec3i)target.m_142538_().m_7495_()), PathComputationType.WATER)) {
                return false;
            }
            if (this.step1Done && !this.step2Done && (!this.attacker.m_20069_() || this.attacker.m_20270_((Entity)target) > 20.0f)) {
                return false;
            }
        }
        if (this.step1Ticks > 100.0) {
            return false;
        }
        if (this.step2Ticks > 100.0) {
            return false;
        }
        if (this.step3Done && !this.step4Done && !this.attacker.f_19853_.m_8055_(this.strikePos).m_60647_((BlockGetter)this.attacker.f_19853_, this.strikePos, PathComputationType.WATER)) {
            return false;
        }
        if (this.step4Ticks > 50.0) {
            return false;
        }
        if (this.step4Done) {
            return false;
        }
        return !this.attacker.isLandNavigator;
    }

    public void m_8056_() {
        this.attacker.m_21561_(true);
        this.panthalassaBreachableEntity.setBreaching(true);
    }

    public void m_8041_() {
        LivingEntity target = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21561_(false);
        this.panthalassaBreachableEntity.setBreaching(false);
        this.panthalassaBreachableEntity.setBreachState(false);
        this.panthalassaBreachableEntity.setBreachCooldown(600.0f);
        if (!this.attacker.m_20197_().isEmpty()) {
            this.attacker.m_20153_();
        }
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.attacker.m_5448_();
        if (!this.step1Done && this.moveStep1()) {
            assert (target != null);
            this.attacker.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            this.step1Done = true;
            this.panthalassaBreachableEntity.setBreachState(true);
        }
        if (this.step1Done && !this.step2Done) {
            assert (target != null);
            if (this.moveStep2()) {
                this.step2Done = true;
                this.jumpStart = target.m_20186_();
                if (target.m_20202_() != null) {
                    target.m_20202_().m_20329_((Entity)this.attacker);
                } else {
                    target.m_20329_((Entity)this.attacker);
                }
                if (this.attacker.m_20184_().f_82480_ < 1.5) {
                    this.attacker.m_20334_(this.attacker.m_20184_().f_82479_, 1.5, this.attacker.m_20184_().f_82481_);
                }
            }
        }
        if (this.step1Done && this.step2Done && !this.step3Done) {
            this.step3Ticks = this.step3Ticks += 1.0;
            if (this.attacker.m_20186_() - this.jumpStart > 5.0) {
                this.crushVehicleAndPassengers();
                if (!this.attacker.m_20197_().isEmpty()) {
                    this.attacker.m_20153_();
                }
                this.panthalassaBreachableEntity.setBreachState(false);
                this.step3Done = true;
            } else if (this.step3Ticks > 30.0 && this.attacker.m_20069_()) {
                this.crushVehicleAndPassengers();
                if (!this.attacker.m_20197_().isEmpty()) {
                    this.attacker.m_20153_();
                }
                this.step3Done = true;
            }
        }
        if (this.step1Done && this.step2Done && this.step3Done && this.moveStep4()) {
            this.step4Done = true;
        }
    }

    public boolean moveStep1() {
        this.step1Ticks = this.step1Ticks += 1.0;
        LivingEntity target = this.attacker.m_5448_();
        assert (target != null);
        this.strikePos = target.m_142538_().m_6625_(12);
        this.attacker.m_21573_().m_26519_((double)this.strikePos.m_123341_(), (double)this.strikePos.m_123342_(), (double)this.strikePos.m_123343_(), this.speedTowardsTarget);
        return this.attacker.m_20275_(target.m_20185_(), target.m_20186_() - 12.0, target.m_20189_()) <= 10.0;
    }

    public boolean moveStep2() {
        this.step2Ticks = this.step2Ticks += 1.0;
        LivingEntity target = this.attacker.m_5448_();
        assert (target != null);
        this.attacker.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        this.attacker.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.speedTowardsTarget * 4.0);
        return this.attacker.m_20270_((Entity)target) < 4.0f;
    }

    public boolean moveStep4() {
        this.step4Ticks = this.step4Ticks += 1.0;
        this.attacker.m_21573_().m_26519_((double)this.strikePos.m_123341_(), (double)this.strikePos.m_123342_(), (double)this.strikePos.m_123343_(), this.speedTowardsTarget);
        return this.attacker.m_20275_(this.strikePos.m_123341_(), this.strikePos.m_123342_(), this.strikePos.m_123343_()) <= 10.0;
    }

    protected void crushVehicleAndPassengers() {
        List entities = this.attacker.f_19853_.m_45933_((Entity)this.attacker, new AABB(this.attacker.m_20185_() - 5.0, this.attacker.m_20186_() - 3.0, this.attacker.m_20189_() - 5.0, this.attacker.m_20185_() + 5.0, this.attacker.m_20186_() + 10.0, this.attacker.m_20189_() + 5.0));
        if (!entities.isEmpty()) {
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            for (Entity entity : entities) {
                this.attacker.m_7327_(entity);
            }
        }
    }
}

