/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.creature.ai.ICrushable;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;

public class PanthalassaCrushAttackGoal
extends Goal {
    protected final PanthalassaEntity attacker;
    protected final ICrushable crushingEntity;
    private final double speedTowardsTarget;
    private Path path;
    private double initialHealth;
    private boolean step1Done;
    private int step1Ticks;
    private int step2Ticks;
    private Entity target;

    public PanthalassaCrushAttackGoal(PanthalassaEntity creature, double speedIn) {
        this.attacker = creature;
        this.crushingEntity = (ICrushable)((Object)creature);
        this.speedTowardsTarget = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.attacker.m_20069_() && !this.attacker.f_19853_.m_8055_(new BlockPos(this.attacker.m_20182_()).m_7495_()).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        if (this.attacker.isLandNavigator) {
            return false;
        }
        if (this.crushingEntity.getCrushCooldown() > 0.0f) {
            return false;
        }
        long i = this.attacker.f_19853_.m_46467_();
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return (double)this.attacker.m_20270_((Entity)livingentity) < 4.0;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.attacker.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        if (this.attacker.isLandNavigator) {
            return false;
        }
        if (!this.attacker.m_20069_()) {
            return false;
        }
        if (this.initialHealth - (double)this.attacker.m_21223_() > 20.0) {
            return false;
        }
        if (this.step1Done && this.attacker.m_20197_().isEmpty()) {
            return false;
        }
        if (this.step1Ticks > 150) {
            return false;
        }
        if (this.step2Ticks > 100) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.attacker.m_21561_(true);
        this.crushingEntity.setCrushing(true);
        this.initialHealth = this.attacker.m_21223_();
    }

    public void m_8041_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21561_(false);
        this.crushingEntity.setCrushingState(false);
        this.crushingEntity.setCrushCooldown(600.0f);
        this.attacker.m_20153_();
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target;
        if (!this.step1Done && (target = this.attacker.m_5448_()) != null && this.moveStep1()) {
            if (target.m_20202_() != null) {
                target.m_20202_().m_20329_((Entity)this.attacker);
                this.target = target.m_20202_();
            } else {
                target.m_20329_((Entity)this.attacker);
                this.target = target;
            }
            this.crushingEntity.setCrushingState(true);
            this.step1Done = true;
        }
        if (this.step1Done) {
            this.attacker.m_21573_().m_26573_();
            ++this.step2Ticks;
            if (this.step2Ticks == 0 || this.step2Ticks == 20 || this.step2Ticks == 40 || this.step2Ticks == 60 || this.step2Ticks == 80 || this.step2Ticks == 100) {
                this.attacker.m_6674_(InteractionHand.MAIN_HAND);
                this.attacker.m_7327_(this.target);
            }
        }
    }

    public boolean moveStep1() {
        this.step1Ticks = ++this.step1Ticks;
        LivingEntity target = this.attacker.m_5448_();
        assert (target != null);
        this.attacker.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        this.attacker.m_21573_().m_26519_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.speedTowardsTarget * 4.0);
        return this.attacker.m_20270_((Entity)target) < 4.0f;
    }
}

