/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.creature.ai;

import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class PanthalassaRandomSwimmingGoal
extends Goal {
    protected final PanthalassaEntity creature;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;
    private boolean checkNoActionTime;
    protected final int avoidDistance;

    public PanthalassaRandomSwimmingGoal(PanthalassaEntity creatureIn, double speedIn, int chance, int avoidDistance) {
        this(creatureIn, speedIn, chance, avoidDistance, false);
    }

    public PanthalassaRandomSwimmingGoal(PanthalassaEntity creature, double speed, int chance, int avoidDistance, boolean checkNATime) {
        this.creature = creature;
        this.speed = speed;
        this.executionChance = chance;
        this.avoidDistance = avoidDistance;
        this.checkNoActionTime = checkNATime;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 vector3d;
        if (this.creature.m_20160_()) {
            return false;
        }
        if (this.creature.m_5448_() != null) {
            return false;
        }
        if (this.creature.isLandNavigator) {
            return false;
        }
        if (!this.creature.m_20069_() && !this.creature.f_19853_.m_8055_(new BlockPos(this.creature.m_20182_()).m_7495_()).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        if (!this.mustUpdate) {
            if (this.checkNoActionTime && this.creature.m_21216_() >= 100) {
                return false;
            }
            if (this.creature.m_21187_().nextInt(this.executionChance) != 0) {
                return false;
            }
        }
        if ((vector3d = this.getPosition()) == null) {
            return false;
        }
        this.x = vector3d.f_82479_;
        this.y = vector3d.f_82480_;
        this.z = vector3d.f_82481_;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 targetVec = BehaviorUtils.m_147444_((PathfinderMob)this.creature, (int)30, (int)20);
        if (targetVec != null) {
            BlockPos targetBlockPos = new BlockPos(targetVec);
            Vec3 creaturePos = this.creature.m_20182_();
            double distance = creaturePos.m_82546_(targetVec).m_82553_();
            if (distance < 10.0) {
                return null;
            }
            for (int i = 0; i <= this.avoidDistance; ++i) {
                if (!this.creature.f_19853_.m_6425_(new BlockPos((Vec3i)targetBlockPos).m_142390_(i)).m_76153_((Tag)FluidTags.f_13131_)) {
                    targetVec = null;
                    break;
                }
                if (!this.creature.f_19853_.m_6425_(new BlockPos((Vec3i)targetBlockPos).m_142383_(i)).m_76153_((Tag)FluidTags.f_13131_)) {
                    targetVec = null;
                    break;
                }
                if (!this.creature.f_19853_.m_6425_(new BlockPos((Vec3i)targetBlockPos).m_142385_(i)).m_76153_((Tag)FluidTags.f_13131_)) {
                    targetVec = null;
                    break;
                }
                if (this.creature.f_19853_.m_6425_(new BlockPos((Vec3i)targetBlockPos).m_142386_(i)).m_76153_((Tag)FluidTags.f_13131_)) continue;
                targetVec = null;
                break;
            }
            return targetVec;
        }
        return null;
    }

    public boolean m_8045_() {
        if (this.creature.m_20275_(this.x, this.y, this.z) < 50.0) {
            return false;
        }
        if (this.creature.isLandNavigator) {
            return false;
        }
        return !this.creature.m_21573_().m_26571_() && !this.creature.m_20160_();
    }

    public void m_8056_() {
        this.creature.m_21573_().m_26519_(this.x, this.y, this.z, this.speed);
    }

    public void m_8041_() {
        this.creature.m_21573_().m_26573_();
        super.m_8041_();
    }
}

