/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class PanthalassaVehicle
extends Entity {
    protected static final EntityDataAccessor<Float> MAX_HEALTH = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> ARMOR = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> NLF_DISTANCE = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> FLOOR_DISTANCE = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> LIGHTS_ON = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> SONAR_LAST_CHECK = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> ENTRY_X = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ENTRY_Z = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> LIGHT_X = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> LIGHT_Y = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> LIGHT_Z = SynchedEntityData.m_135353_(PanthalassaVehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float waterSpeed;
    public float landSpeed;
    public static float aiMoveSpeed;
    protected int newPosRotationIncrements;
    protected double interpTargetX;
    protected double interpTargetY;
    protected double interpTargetZ;
    protected double interpTargetYaw;
    protected double interpTargetPitch;
    public float moveStrafing;
    public float moveVertical;
    public float moveForward;
    public float jumpMovementFactor = 0.02f;
    public float checkedNLFDistance;
    public int checkedFloorDistance;
    public BlockPos prevPos;
    public BlockState blockLightWater = ((Block)PanthalassaBlocks.LIGHT_WATER.get()).m_49966_();
    public BlockState blockLightAir = ((Block)PanthalassaBlocks.LIGHT_AIR.get()).m_49966_();
    public ResourceKey<Level> prevDimension;

    public PanthalassaVehicle(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(NLF_DISTANCE, (Object)Float.valueOf(-1.0f));
        this.f_19804_.m_135372_(FLOOR_DISTANCE, (Object)-1);
        this.f_19804_.m_135372_(LIGHTS_ON, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SONAR_LAST_CHECK, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ENTRY_X, (Object)0);
        this.f_19804_.m_135372_(ENTRY_Z, (Object)0);
        this.f_19804_.m_135372_(LIGHT_X, (Object)0);
        this.f_19804_.m_135372_(LIGHT_Y, (Object)0);
        this.f_19804_.m_135372_(LIGHT_Z, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("MaxHealth")) {
            this.setMaxHealth(compound.m_128457_("MaxHealth"));
        }
        if (compound.m_128441_("Health")) {
            this.setHealth(compound.m_128457_("Health"));
        }
        if (compound.m_128441_("Armor")) {
            this.setArmor(compound.m_128457_("Armor"));
        }
        if (compound.m_128441_("NLFDistance")) {
            this.setNLFDistance(compound.m_128457_("NLFDistance"));
        }
        if (compound.m_128441_("FloorDistance")) {
            this.setFloorDistance(compound.m_128451_("FloorDistance"));
        }
        if (compound.m_128441_("LightsOn")) {
            this.setLightsOn(compound.m_128471_("LightsOn"));
        }
        if (compound.m_128441_("SonarLastCheck")) {
            this.setSonarLastCheck(compound.m_128457_("SonarLastCheck"));
        }
        if (compound.m_128441_("LightX")) {
            this.setLightPosX(compound.m_128451_("LightX"));
        }
        if (compound.m_128441_("LightY")) {
            this.setLightPosY(compound.m_128451_("LightY"));
        }
        if (compound.m_128441_("LightZ")) {
            this.setLightPosZ(compound.m_128451_("LightZ"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("MaxHealth", this.getMaxHealth());
        compound.m_128350_("Health", this.getHealth());
        compound.m_128350_("Armor", this.getArmor());
        compound.m_128350_("NLFDistance", this.getNLFDistance());
        compound.m_128405_("FloorDistance", this.getFloorDistance());
        compound.m_128379_("LightsOn", this.getLightsOn());
        compound.m_128350_("SonarLastCheck", this.getSonarLastCheck());
        compound.m_128405_("LightX", this.getLightPos().m_123341_());
        compound.m_128405_("LightY", this.getLightPos().m_123342_());
        compound.m_128405_("LightZ", this.getLightPos().m_123343_());
    }

    public static boolean canVehicleCollide(Entity p_242378_0_, Entity entity) {
        return (entity.m_5829_() || entity.m_6094_()) && !p_242378_0_.m_20365_(entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_7337_(Entity entity) {
        return PanthalassaVehicle.canVehicleCollide(this, entity);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.f_19853_.f_46443_ && this.m_7310_(this)) {
            return player.m_20329_((Entity)this) ? InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected boolean m_7310_(Entity vehicle) {
        return this.m_20197_().size() < 1;
    }

    @Nullable
    public Entity m_6688_() {
        List passengers = this.m_20197_();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    public float getTravelSpeed() {
        return this.m_20069_() ? this.waterSpeed : this.landSpeed;
    }

    public float getAIMoveSpeed() {
        return aiMoveSpeed;
    }

    public void setAIMoveSpeed(float speedIn) {
        aiMoveSpeed = speedIn;
    }

    public void m_8119_() {
        super.m_8119_();
        List passengers = this.m_20197_();
        if (this.f_19853_.m_46472_() == PanthalassaDimension.PANTHALASSA && this.prevDimension != PanthalassaDimension.PANTHALASSA) {
            this.setEntryX((int)this.m_20182_().f_82479_);
            this.setEntryZ((int)this.m_20182_().f_82481_);
        } else if (this.prevDimension == PanthalassaDimension.PANTHALASSA && this.f_19853_.m_46472_() != PanthalassaDimension.PANTHALASSA) {
            this.setEntryX(0);
            this.setEntryZ(0);
        }
        if (!passengers.isEmpty()) {
            for (Entity passenger : passengers) {
                LivingEntity currentPassenger = (LivingEntity)passenger;
                currentPassenger.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 10, 0));
            }
        }
        if (this.prevPos != null) {
            BlockPos prevLight;
            Vec3 prevPosV = new Vec3((double)this.prevPos.m_123341_(), (double)this.prevPos.m_123342_(), (double)this.prevPos.m_123343_());
            BlockPos vehiclePos = this.m_142538_();
            Vec3 vehiclePosV = new Vec3((double)vehiclePos.m_123341_(), (double)vehiclePos.m_123342_(), (double)vehiclePos.m_123343_());
            double distanceMoved = prevPosV.m_82546_(vehiclePosV).m_82553_();
            boolean hasLooped = false;
            BlockState vehiclePosBlockState = this.f_19853_.m_8055_(vehiclePos);
            if ((distanceMoved > 1.0 || !this.m_20069_() && this.m_20096_() && distanceMoved > 0.2 || !this.getLightsOn()) && (prevLight = this.getLightPos()) != null) {
                if (this.f_19853_.m_8055_(prevLight) == this.blockLightWater) {
                    if (this.getLightsOn() && this.m_20069_()) {
                        this.f_19853_.m_7731_(vehiclePos, this.blockLightWater, 2);
                        this.setLightPos(vehiclePos);
                    } else if (this.getLightsOn() && !this.m_20069_() && this.m_20096_()) {
                        this.f_19853_.m_7731_(vehiclePos, this.blockLightAir, 2);
                        this.setLightPos(vehiclePos);
                    }
                    this.f_19853_.m_7731_(prevLight, Blocks.f_49990_.m_49966_(), 2);
                }
                if (this.f_19853_.m_8055_(prevLight) == this.blockLightAir) {
                    if (this.getLightsOn() && !this.m_20069_() && this.m_20096_()) {
                        this.f_19853_.m_7731_(vehiclePos, this.blockLightAir, 2);
                        this.setLightPos(vehiclePos);
                    } else if (this.getLightsOn() && this.m_20069_()) {
                        this.f_19853_.m_7731_(vehiclePos, this.blockLightWater, 2);
                        this.setLightPos(vehiclePos);
                    }
                    this.f_19853_.m_7731_(prevLight, Blocks.f_50016_.m_49966_(), 2);
                }
                hasLooped = true;
            }
            if (!hasLooped && vehiclePosBlockState != this.blockLightWater && vehiclePosBlockState != this.blockLightAir) {
                prevLight = this.getLightPos();
                if (this.getLightsOn() && this.m_20069_() && this.f_19853_.m_8055_(this.getLightPos()) != ((Block)PanthalassaBlocks.LIGHT_WATER.get()).m_49966_()) {
                    this.f_19853_.m_7731_(vehiclePos, this.blockLightWater, 2);
                    this.setLightPos(vehiclePos);
                    if (prevLight != null) {
                        if (this.f_19853_.m_8055_(prevLight) == this.blockLightWater) {
                            this.f_19853_.m_7731_(prevLight, Blocks.f_49990_.m_49966_(), 2);
                        } else if (this.f_19853_.m_8055_(prevLight) == this.blockLightAir) {
                            this.f_19853_.m_7731_(prevLight, Blocks.f_50016_.m_49966_(), 2);
                        }
                    }
                } else if (this.getLightsOn() && !this.m_20069_() && this.m_20096_() && this.f_19853_.m_8055_(this.getLightPos()) != ((Block)PanthalassaBlocks.LIGHT_AIR.get()).m_49966_()) {
                    this.f_19853_.m_7731_(vehiclePos, this.blockLightAir, 2);
                    this.setLightPos(vehiclePos);
                    if (prevLight != null) {
                        if (this.f_19853_.m_8055_(prevLight) == this.blockLightWater) {
                            this.f_19853_.m_7731_(prevLight, Blocks.f_49990_.m_49966_(), 2);
                        } else if (this.f_19853_.m_8055_(prevLight) == this.blockLightAir) {
                            this.f_19853_.m_7731_(prevLight, Blocks.f_50016_.m_49966_(), 2);
                        }
                    }
                }
            }
        }
        this.prevPos = this.m_142538_();
        this.prevDimension = this.f_19853_.m_46472_();
        this.vehicleTick();
    }

    public void vehicleTick() {
        if (this.m_6109_()) {
            this.newPosRotationIncrements = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        Vec3 vector3d = this.m_20184_();
        double d1 = vector3d.f_82479_;
        double d3 = vector3d.f_82480_;
        double d5 = vector3d.f_82481_;
        if (Math.abs(vector3d.f_82479_) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vector3d.f_82480_) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vector3d.f_82481_) < 0.003) {
            d5 = 0.0;
        }
        this.m_20334_(d1, d3, d5);
        this.f_19853_.m_46473_().m_6180_("ai");
        if (this.isServerWorld()) {
            this.f_19853_.m_46473_().m_6180_("newAi");
            this.updateEntityActionState();
            this.f_19853_.m_46473_().m_7238_();
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("travel");
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.vehicleTravel(new Vec3((double)this.moveStrafing, (double)this.moveVertical, (double)this.moveForward));
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("push");
        this.f_19853_.m_46473_().m_7238_();
    }

    protected void updateEntityActionState() {
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public boolean isServerWorld() {
        return !this.f_19853_.f_46443_;
    }

    public void vehicleTravel(Vec3 vec3d) {
        if (this.m_20069_()) {
            if (this.m_6688_() instanceof LivingEntity) {
                float speed = this.getTravelSpeed();
                LivingEntity entity = (LivingEntity)this.m_6688_();
                double moveY = vec3d.f_82480_;
                double moveX = vec3d.f_82479_;
                double moveZ = entity.f_20902_;
                this.f_19857_ = entity.f_19857_;
                this.f_19858_ = entity.f_19858_ * 0.5f;
                double lookY = entity.m_20154_().f_82480_;
                if (entity.f_20902_ != 0.0f && (this.m_5842_() || lookY < 0.0)) {
                    moveY = lookY;
                }
                this.setAIMoveSpeed(speed);
                vec3d = new Vec3(moveX, moveY, moveZ);
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
            }
            this.m_19920_(this.getAIMoveSpeed(), vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else if (this.m_20096_()) {
            if (this.m_6688_() instanceof LivingEntity) {
                float speed = this.getTravelSpeed();
                LivingEntity entity = (LivingEntity)this.m_6688_();
                double moveY = vec3d.f_82480_;
                double moveX = vec3d.f_82479_;
                double moveZ = entity.f_20902_;
                this.f_19857_ = entity.f_19857_;
                this.setAIMoveSpeed(speed);
                vec3d = new Vec3(moveX, moveY, moveZ);
            }
            this.m_19920_(this.getAIMoveSpeed(), vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (vec3d.f_82481_ == 0.0) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
            }
        } else if (!this.m_20096_()) {
            if (this.m_6688_() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)this.m_6688_();
                this.f_19857_ = entity.f_19857_;
                this.f_19858_ = entity.f_19858_ * 0.5f;
            }
            double d0 = 0.08;
            BlockPos blockpos = this.m_20099_();
            float f3 = this.f_19853_.m_8055_(this.m_20099_()).getFriction((LevelReader)this.f_19853_, this.m_20099_(), (Entity)this);
            Vec3 vec5 = this.handleRelativeFrictionAndCalculateMovement(vec3d, f3);
            double d2 = vec5.f_82480_;
            if (this.f_19853_.f_46443_ && !this.f_19853_.m_46805_(blockpos)) {
                d2 = this.m_20186_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.m_20068_()) {
                d2 -= d0;
            }
            this.m_20334_(this.m_20184_().m_7096_(), d2 * (double)0.98f, this.m_20184_().m_7094_());
        }
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 vec3d, float d3) {
        this.m_19920_(this.getRelevantMoveFactor(d3), vec3d);
        this.m_20256_(this.m_20184_());
        this.m_6478_(MoverType.SELF, this.m_20184_());
        return this.m_20184_();
    }

    private float getRelevantMoveFactor(float p_213335_1_) {
        return this.f_19861_ ? this.getAIMoveSpeed() * (0.21600002f / (p_213335_1_ * p_213335_1_ * p_213335_1_)) : this.jumpMovementFactor;
    }

    public boolean m_6469_(@Nullable DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            boolean isCreativeMode;
            Entity trueSource = source.m_7639_();
            if (source instanceof IndirectEntityDamageSource && trueSource != null && this.m_20363_(trueSource)) {
                return false;
            }
            float adjustedAmount = (100.0f - this.getArmor()) / 100.0f > 0.0f ? amount * ((100.0f - this.getArmor()) / 100.0f) : 0.0f;
            this.setHealth(this.getHealth() - adjustedAmount);
            boolean bl = isCreativeMode = trueSource instanceof Player && ((Player)trueSource).m_7500_();
            if (isCreativeMode || this.getHealth() < 0.0f) {
                AABB searchArea = new AABB(this.m_20185_() - 10.0, this.m_20186_() - 10.0, this.m_20189_() - 10.0, this.m_20185_() + 10.0, this.m_20186_() + 10.0, this.m_20189_() + 10.0);
                Set set = BlockPos.m_121921_((AABB)searchArea).map(pos -> new BlockPos((Vec3i)pos)).filter(state -> this.f_19853_.m_8055_(state) == ((Block)PanthalassaBlocks.LIGHT_WATER.get()).m_49966_() || this.f_19853_.m_8055_(state) == ((Block)PanthalassaBlocks.LIGHT_AIR.get()).m_49966_()).collect(Collectors.toSet());
                for (BlockPos lightPos : set) {
                    if (this.f_19853_.m_8055_(lightPos) == ((Block)PanthalassaBlocks.LIGHT_WATER.get()).m_49966_()) {
                        this.f_19853_.m_7731_(lightPos, Blocks.f_49990_.m_49966_(), 2);
                    }
                    if (this.f_19853_.m_8055_(lightPos) != ((Block)PanthalassaBlocks.LIGHT_AIR.get()).m_49966_()) continue;
                    this.f_19853_.m_7731_(lightPos, Blocks.f_50016_.m_49966_(), 2);
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public void setHealth(float health) {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(Math.min(this.getMaxHealth(), health)));
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    public float getMaxHealth() {
        return ((Float)this.f_19804_.m_135370_(MAX_HEALTH)).floatValue();
    }

    public void setMaxHealth(float maxHealth) {
        this.f_19804_.m_135381_(MAX_HEALTH, (Object)Float.valueOf(maxHealth));
    }

    public void setArmor(float armor) {
        this.f_19804_.m_135381_(ARMOR, (Object)Float.valueOf(armor));
    }

    public float getArmor() {
        return ((Float)this.f_19804_.m_135370_(ARMOR)).floatValue();
    }

    public float testNLFDistance(PanthalassaVehicle vehicle) {
        List entities = this.f_19853_.m_45933_((Entity)vehicle, new AABB(vehicle.m_20185_() - 20.0, vehicle.m_20186_() - 20.0, vehicle.m_20189_() - 20.0, vehicle.m_20185_() + 20.0, vehicle.m_20186_() + 20.0, vehicle.m_20189_() + 20.0));
        float closestDistance = 100.0f;
        if (entities.size() != 0) {
            for (Entity testEntity : entities) {
                float distance;
                if (!(testEntity instanceof LivingEntity) || testEntity instanceof Player || !((distance = this.m_20270_(testEntity)) < closestDistance)) continue;
                closestDistance = distance;
            }
            if (closestDistance < 20.0f && closestDistance > 0.0f) {
                return closestDistance;
            }
        }
        return -1.0f;
    }

    public void setNLFDistance(float nlfDistance) {
        this.f_19804_.m_135381_(NLF_DISTANCE, (Object)Float.valueOf(nlfDistance));
    }

    public float getNLFDistance() {
        return ((Float)this.f_19804_.m_135370_(NLF_DISTANCE)).floatValue();
    }

    public int testFloorDistance(PanthalassaVehicle vehicle, Level world) {
        BlockPos pos = vehicle.m_142538_();
        while (pos.m_123342_() > 0) {
            if (!world.m_8055_(pos).m_60815_()) {
                pos = pos.m_7495_();
                continue;
            }
            return vehicle.m_142538_().m_123342_() - pos.m_123342_();
        }
        return -1;
    }

    public void setFloorDistance(int floorDistance) {
        this.f_19804_.m_135381_(FLOOR_DISTANCE, (Object)floorDistance);
    }

    public int getFloorDistance() {
        return (Integer)this.f_19804_.m_135370_(FLOOR_DISTANCE);
    }

    public void setLightsOn(boolean lightState) {
        this.f_19804_.m_135381_(LIGHTS_ON, (Object)lightState);
    }

    public boolean getLightsOn() {
        return (Boolean)this.f_19804_.m_135370_(LIGHTS_ON);
    }

    public void setSonarLastCheck(float lastCheck) {
        this.f_19804_.m_135381_(SONAR_LAST_CHECK, (Object)Float.valueOf(lastCheck));
    }

    public float getSonarLastCheck() {
        return ((Float)this.f_19804_.m_135370_(SONAR_LAST_CHECK)).floatValue();
    }

    public void setEntryX(int x) {
        this.f_19804_.m_135381_(ENTRY_X, (Object)x);
    }

    public float getEntryX() {
        return ((Integer)this.f_19804_.m_135370_(ENTRY_X)).intValue();
    }

    public void setEntryZ(int z) {
        this.f_19804_.m_135381_(ENTRY_Z, (Object)z);
    }

    public float getEntryZ() {
        return ((Integer)this.f_19804_.m_135370_(ENTRY_Z)).intValue();
    }

    public void setLightPosX(int x) {
        this.f_19804_.m_135381_(LIGHT_X, (Object)x);
    }

    public void setLightPosY(int y) {
        this.f_19804_.m_135381_(LIGHT_Y, (Object)y);
    }

    public void setLightPosZ(int z) {
        this.f_19804_.m_135381_(LIGHT_Z, (Object)z);
    }

    public void setLightPos(BlockPos blockPos) {
        this.f_19804_.m_135381_(LIGHT_X, (Object)blockPos.m_123341_());
        this.f_19804_.m_135381_(LIGHT_Y, (Object)blockPos.m_123342_());
        this.f_19804_.m_135381_(LIGHT_Z, (Object)blockPos.m_123343_());
    }

    public BlockPos getLightPos() {
        BlockPos blockpos = new BlockPos(((Integer)this.f_19804_.m_135370_(LIGHT_X)).intValue(), ((Integer)this.f_19804_.m_135370_(LIGHT_Y)).intValue(), ((Integer)this.f_19804_.m_135370_(LIGHT_Z)).intValue());
        return blockpos;
    }

    public void respondKeybindSpecial() {
    }

    public void respondKeybindSonar() {
        if (!this.m_20197_().isEmpty() && (float)this.f_19853_.m_46467_() - this.getSonarLastCheck() > 10.0f) {
            this.setSonarLastCheck(this.f_19853_.m_46467_());
            this.checkedNLFDistance = this.testNLFDistance(this);
            this.setNLFDistance(this.checkedNLFDistance);
            this.checkedFloorDistance = this.testFloorDistance(this, this.f_19853_);
            this.setFloorDistance(this.checkedFloorDistance);
        }
    }

    public void respondKeybindLight() {
        this.setLightsOn(!this.getLightsOn());
    }
}

