/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VehicleAGII
extends PanthalassaVehicle
implements IAnimatable {
    public float deltaRotation;
    protected static final EntityDataAccessor<Boolean> NET_ACTIVATED = SynchedEntityData.m_135353_(VehicleAGII.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> NET_CATCH = SynchedEntityData.m_135353_(VehicleAGII.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public VehicleAGII(EntityType<? extends PanthalassaVehicle> type, Level world) {
        super(type, world);
        this.waterSpeed = 0.032f;
        this.landSpeed = 0.004f;
    }

    public VehicleAGII(Level p_i1705_1_, double x, double y, double z) {
        this((EntityType<? extends PanthalassaVehicle>)((EntityType)PanthalassaEntityTypes.AGII.get()), p_i1705_1_);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)Float.valueOf(200.0f));
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(200.0f));
        this.f_19804_.m_135372_(ARMOR, (Object)Float.valueOf(40.0f));
        this.f_19804_.m_135372_(NET_ACTIVATED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(NET_CATCH, (Object)Boolean.FALSE);
        super.m_8097_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("netActivated")) {
            this.setNetActivated(compound.m_128471_("netActivated"));
        }
        if (compound.m_128441_("netCatch")) {
            this.setNetCatch(compound.m_128471_("netCatch"));
        }
        super.m_7378_(compound);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("netActivated", this.getNetActivated());
        compound.m_128379_("netCatch", this.getNetCatch());
        super.m_7380_(compound);
    }

    @Override
    protected boolean m_7310_(Entity vehicle) {
        return this.m_20197_().size() < 2;
    }

    public double m_6048_() {
        return 0.6;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getNetActivated()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ag2.hook_deploy_hold", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void m_8119_() {
        if (this.getNetActivated() && this.m_20069_() && this.m_6084_() && !this.getNetCatch() && this.attemptNet(this)) {
            this.setNetCatch(true);
        }
        if (!this.getNetActivated() && this.getNetCatch()) {
            if (this.releaseNet(this)) {
                // empty if block
            }
            this.setNetCatch(false);
        }
        List passengers = this.m_20197_();
        if (this.getNetCatch() && passengers.size() > 1) {
            LivingEntity netTarget = (LivingEntity)passengers.get(1);
            netTarget.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 20));
        }
        if (!this.m_20197_().isEmpty() && !(this.m_20197_().get(0) instanceof Player)) {
            this.m_20153_();
            this.setNetCatch(false);
        }
        super.m_8119_();
    }

    @Override
    public void respondKeybindSpecial() {
        if (!this.f_19853_.f_46443_) {
            if (!this.getNetActivated() && this.m_20069_()) {
                this.setNetActivated(true);
            } else if (this.getNetActivated()) {
                this.setNetActivated(false);
            }
        }
    }

    @Override
    public float getTravelSpeed() {
        if (this.getNetActivated() && this.m_20069_()) {
            return this.waterSpeed * 0.8f;
        }
        if (this.m_20069_()) {
            return this.waterSpeed;
        }
        return this.landSpeed;
    }

    public boolean attemptNet(PanthalassaVehicle vehicle) {
        if (!this.getNetCatch() && this.getNetActivated()) {
            List entities = this.f_19853_.m_45933_((Entity)vehicle, new AABB(vehicle.m_20185_() - 5.0, vehicle.m_20186_() - 5.0, vehicle.m_20189_() - 5.0, vehicle.m_20185_() + 5.0, vehicle.m_20186_() + 5.0, vehicle.m_20189_() + 5.0));
            float closestDistance = 100.0f;
            if (entities.size() != 0) {
                for (Entity testEntity : entities) {
                    if (!(testEntity instanceof LivingEntity) || testEntity instanceof Player || testEntity.m_20202_() != null) continue;
                    float distance = this.m_20270_(testEntity);
                    if (distance < closestDistance) {
                        closestDistance = distance;
                        if (!(closestDistance < 5.0f)) continue;
                        testEntity.m_20329_((Entity)this);
                        if (this.m_20197_().isEmpty()) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public boolean releaseNet(PanthalassaVehicle vehicle) {
        List passengers = this.m_20197_();
        if (this.getNetCatch() && !this.getNetActivated() && passengers.size() > 1) {
            ((Entity)passengers.get(1)).m_8127_();
            return true;
        }
        return false;
    }

    public void setNetActivated(boolean active) {
        this.f_19804_.m_135381_(NET_ACTIVATED, (Object)active);
    }

    public boolean getNetActivated() {
        return (Boolean)this.f_19804_.m_135370_(NET_ACTIVATED);
    }

    public void setNetCatch(boolean target) {
        this.f_19804_.m_135381_(NET_CATCH, (Object)target);
    }

    public boolean getNetCatch() {
        return (Boolean)this.f_19804_.m_135370_(NET_CATCH);
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = 0.0f;
            float f1 = (float)((!this.m_6084_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            float f2 = 0.06f;
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(passenger);
                if (i == 0) {
                    f = 0.0f;
                    f2 = 0.0f;
                } else {
                    f = -1.0f;
                    f2 = -2.0f;
                }
            }
            Vec3 vector3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.f_19857_ * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + (double)f1 + (double)f2, this.m_20189_() + vector3d.f_82481_);
            passenger.f_19857_ += this.deltaRotation;
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
        }
    }
}

