/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.entity.vehicle;

import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.registry.PanthalassaEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class VehicleMRSV
extends PanthalassaVehicle
implements IAnimatable {
    protected static final EntityDataAccessor<Boolean> IS_BOOSTING = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> BOOST_COOLDOWN = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> BOOSTING_TIMER = SynchedEntityData.m_135353_(VehicleMRSV.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public VehicleMRSV(EntityType<? extends PanthalassaVehicle> type, Level world) {
        super(type, world);
        this.waterSpeed = 0.042f;
        this.landSpeed = 0.004f;
    }

    public VehicleMRSV(Level p_i1705_1_, double x, double y, double z) {
        this((EntityType<? extends PanthalassaVehicle>)((EntityType)PanthalassaEntityTypes.MRSV.get()), p_i1705_1_);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(ARMOR, (Object)Float.valueOf(20.0f));
        this.f_19804_.m_135372_(IS_BOOSTING, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(BOOST_COOLDOWN, (Object)Float.valueOf(20.0f));
        this.f_19804_.m_135372_(BOOSTING_TIMER, (Object)Float.valueOf(0.0f));
        super.m_8097_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("isBoosting")) {
            this.setIsBoosting(compound.m_128471_("isBoosting"));
        }
        if (compound.m_128441_("boostCooldown")) {
            this.setBoostCooldown(compound.m_128457_("boostCooldown"));
        }
        if (compound.m_128441_("boostingTimer")) {
            this.setBoostingTimer(compound.m_128457_("boostingTimer"));
        }
        super.m_7378_(compound);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("isBoosting", this.getIsBoosting());
        compound.m_128350_("boostCooldown", this.getBoostCooldown());
        compound.m_128350_("boostingTimer", this.getBoostingTimer());
        super.m_7380_(compound);
    }

    public double m_6048_() {
        return 0.15;
    }

    public <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public void m_8119_() {
        this.setBoostCooldown(this.getBoostCooldown() - 1.0f);
        if (this.getIsBoosting()) {
            this.setBoostingTimer(this.getBoostingTimer() + 1.0f);
            if (this.getBoostingTimer() > 50.0f) {
                this.setIsBoosting(false);
                this.setBoostingTimer(0.0f);
            }
        }
        super.m_8119_();
    }

    @Override
    public void respondKeybindSpecial() {
        if (!this.f_19853_.f_46443_ && this.getBoostCooldown() < 0.0f && this.m_20069_()) {
            this.setIsBoosting(true);
            this.setBoostCooldown(400.0f);
        }
    }

    @Override
    public float getTravelSpeed() {
        if (this.getIsBoosting() && this.m_20069_()) {
            return this.waterSpeed * 4.0f;
        }
        if (this.m_20069_()) {
            return this.waterSpeed;
        }
        return this.landSpeed;
    }

    public void setBoostingTimer(float cooldown) {
        this.f_19804_.m_135381_(BOOSTING_TIMER, (Object)Float.valueOf(cooldown));
    }

    public float getBoostingTimer() {
        return ((Float)this.f_19804_.m_135370_(BOOSTING_TIMER)).floatValue();
    }

    public void setIsBoosting(boolean isBoosting) {
        this.f_19804_.m_135381_(IS_BOOSTING, (Object)isBoosting);
    }

    public boolean getIsBoosting() {
        return (Boolean)this.f_19804_.m_135370_(IS_BOOSTING);
    }

    public void setBoostCooldown(float cooldown) {
        this.f_19804_.m_135381_(BOOST_COOLDOWN, (Object)Float.valueOf(cooldown));
    }

    public float getBoostCooldown() {
        return ((Float)this.f_19804_.m_135370_(BOOST_COOLDOWN)).floatValue();
    }
}

