/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.events;

import com.github.sniffity.panthalassa.config.PanthalassaCommonConfig;
import com.github.sniffity.panthalassa.server.entity.creature.PanthalassaEntity;
import com.github.sniffity.panthalassa.server.entity.vehicle.PanthalassaVehicle;
import com.github.sniffity.panthalassa.server.network.PanthalassaPacketHandler;
import com.github.sniffity.panthalassa.server.network.packets.PacketCameraSwitch;
import com.github.sniffity.panthalassa.server.registry.PanthalassaBlocks;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import vazkii.patchouli.api.PatchouliAPI;

@Mod.EventBusSubscriber(modid="panthalassa")
public class PanthalassaEventListener {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Entity vehicle;
        Player player = event.getPlayer();
        if (player != null && (vehicle = player.m_20202_()) instanceof PanthalassaVehicle) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingHurtEvent event) {
        Player player;
        Entity vehicle;
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player && (vehicle = (player = (Player)livingEntity).m_20202_()) instanceof PanthalassaVehicle) {
            event.setCanceled(true);
            vehicle.m_6469_(event.getSource(), event.getAmount());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && EntitySelector.f_20406_.test(entity) && entity.f_19853_.m_46472_() == PanthalassaDimension.PANTHALASSA && !(entity instanceof PanthalassaEntity) && (entity.m_20202_() == null || !(entity.m_20202_() instanceof PanthalassaVehicle))) {
            entity.m_6469_(DamageSource.f_19311_, 100.0f);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)event.getEntity();
            BlockState blockstate = event.getPlacedBlock();
            if (blockstate.m_60734_() == PanthalassaBlocks.PORTAL.get()) {
                event.setCanceled(true);
                player.m_6352_((Component)new TranslatableComponent("block.panthalassa.panthalassa_portal.message"), Util.f_137441_);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        Entity entity = event.getEntityMounting();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (event.isMounting() && event.getEntityBeingMounted() instanceof PanthalassaVehicle) {
                PanthalassaPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PacketCameraSwitch());
            }
        }
    }

    @SubscribeEvent
    public static void onPLayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundTag playerData;
        CompoundTag data;
        if (((Boolean)PanthalassaCommonConfig.giveJournal.get()).booleanValue() && (data = (playerData = event.getPlayer().getPersistentData()).m_128469_("PlayerPersisted")) != null && !data.m_128471_("panthalassa_received_journal")) {
            ItemHandlerHelper.giveItemToPlayer((Player)event.getPlayer(), (ItemStack)PatchouliAPI.get().getBookStack(new ResourceLocation("panthalassa", "journal")));
            data.m_128379_("panthalassa_received_journal", true);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }
}

