/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.registry;

import com.github.sniffity.panthalassa.server.world.gen.structure.StructurePanthalassaLaboratory;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class PanthalassaStructures {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"panthalassa");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> PANTHALASSA_LABORATORY = STRUCTURES.register("panthalassa_laboratory", () -> new StructurePanthalassaLaboratory((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    public static void setupStructures() {
        PanthalassaStructures.setupMapSpacingAndLand((StructureFeature)PANTHALASSA_LABORATORY.get(), new StructureFeatureConfiguration(20, 10, 42424242), true);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureSeparationSettings, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureSeparationSettings).build();
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }
}

