/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.gen.structure;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class StructurePanthalassaLaboratory
extends StructureFeature<JigsawConfiguration> {
    public StructurePanthalassaLaboratory(Codec<JigsawConfiguration> codec) {
        super(codec, StructurePanthalassaLaboratory::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    protected static int isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos centerOfChunk = context.f_197355_().m_45615_();
        int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
        BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
        if (topBlock.m_60819_().m_76153_((Tag)FluidTags.f_13131_)) {
            int i = 0;
            while (!topBlock.m_60815_()) {
                topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_6630_(landHeight - ++i).m_123342_());
            }
            float yHeight = centerOfChunk.m_6630_(landHeight - i).m_123342_();
            int x = centerOfChunk.m_123341_() * 16;
            int z = centerOfChunk.m_123343_() * 16;
            BlockPos centerPos = new BlockPos((double)x, (double)yHeight, (double)z);
            return (int)yHeight;
        }
        return 100;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int yHeight = StructurePanthalassaLaboratory.isFeatureChunk(context);
        if (yHeight > 42) {
            return Optional.empty();
        }
        JigsawConfiguration newConfig = new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(new ResourceLocation("panthalassa", "panthalassa_laboratory/start_pool")), 10);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        BlockPos blockpos1 = new BlockPos(blockpos.m_123341_(), yHeight, blockpos.m_123343_());
        Optional structurePiecesGenerator = JigsawPlacement.m_197210_((PieceGeneratorSupplier.Context)newContext, PoolElementStructurePiece::new, (BlockPos)blockpos1, (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }
}

