/*
 * Decompiled with CFR 0.152.
 */
package com.github.sniffity.panthalassa.server.world.teleporter;

import com.github.sniffity.panthalassa.Panthalassa;
import com.github.sniffity.panthalassa.server.block.BlockPortal;
import com.github.sniffity.panthalassa.server.block.BlockPortalBlockEntity;
import com.github.sniffity.panthalassa.server.registry.PanthalassaDimension;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class PanthalassaTeleporter
implements ITeleporter {
    protected final ServerLevel world;

    public PanthalassaTeleporter(ServerLevel worldIn) {
        this.world = worldIn;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, BlockPos portalBlockPos) {
        Optional<BlockUtil.FoundRectangle> result = this.makePortalFromPos(destWorld, entity.f_19853_, portalBlockPos);
        if (result.isPresent()) {
            BlockPos startPos = result.get().f_124348_;
            if (destWorld.m_46472_() == PanthalassaDimension.PANTHALASSA) {
                return new PortalInfo(new Vec3((double)startPos.m_123341_(), (double)startPos.m_123342_(), (double)startPos.m_123343_()), entity.m_20184_(), entity.f_19857_, entity.f_19858_);
            }
            destWorld.m_46865_(new BlockPos(startPos.m_123341_(), startPos.m_123342_(), startPos.m_123343_()));
            return new PortalInfo(new Vec3((double)startPos.m_123341_(), (double)startPos.m_123342_(), (double)startPos.m_123343_()), entity.m_20184_(), entity.f_19857_, entity.f_19858_);
        }
        return null;
    }

    private boolean checkRegionForPlacement(BlockPos potentialPos, Level world) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int x = -8; x < 9; ++x) {
            for (int y = -1; y > -5; --y) {
                for (int z = -8; z < 9; ++z) {
                    check.m_122178_(potentialPos.m_123341_() + x, potentialPos.m_123342_() + y, potentialPos.m_123343_() + z);
                    if (world.m_6425_((BlockPos)check).m_76153_((Tag)FluidTags.f_13131_)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Optional<BlockUtil.FoundRectangle> makePortalFromPos(ServerLevel destWorld, Level originalWorld, @Nonnull BlockPos originalPosition) {
        BlockPortalBlockEntity centerTE;
        if (destWorld.m_46472_() == Level.f_46428_) {
            Panthalassa.LOGGER.warn("Corresponding Overworld Portal not found!");
            Panthalassa.LOGGER.warn("Teleporting to spawn");
            BlockPos spawnPoint = new BlockPos(destWorld.m_8900_().m_123341_(), destWorld.m_8900_().m_123342_(), destWorld.m_8900_().m_123343_());
            return Optional.of(new BlockUtil.FoundRectangle(spawnPoint.m_7949_(), 1, 1));
        }
        BlockPos destPosition = new BlockPos(originalPosition.m_123341_(), destWorld.m_141928_() - 5, originalPosition.m_123343_());
        destPosition = this.getValidPortalLocation(destWorld, originalPosition, destPosition);
        BlockPortal.matchShapeSize portalMatch = new BlockPortal.matchShapeSize((LevelAccessor)destWorld, destPosition, true);
        BlockPortalBlockEntity tempTE = this.getPortalTE((LevelAccessor)originalWorld, originalPosition);
        if (tempTE != null && (centerTE = this.getPortalTE((LevelAccessor)originalWorld, originalPosition.m_141950_((Vec3i)tempTE.offsetFromCenter))) != null) {
            portalMatch.linkPortalCenters((LevelAccessor)originalWorld, centerTE.m_58899_());
        }
        return Optional.of(new BlockUtil.FoundRectangle(destPosition.m_7949_(), 15, 1));
    }

    private BlockPos getValidPortalLocation(ServerLevel destWorld, BlockPos originalPosition, BlockPos destPosition) {
        int newSpotOffset = 16;
        int radiusCheckLimit = 500;
        BlockPos.MutableBlockPos currentPosition = new BlockPos.MutableBlockPos().m_122190_((Vec3i)destPosition);
        for (int currentRadius = 0; currentRadius <= radiusCheckLimit; currentRadius += newSpotOffset) {
            for (int x = -currentRadius; x <= currentRadius; x += newSpotOffset) {
                for (int z = -currentRadius; z <= currentRadius; z += newSpotOffset) {
                    if (Math.abs(x) != currentRadius) continue;
                    currentPosition.m_122190_((Vec3i)destPosition).m_122184_(x, 0, z);
                    while (currentPosition.m_123342_() > -1) {
                        currentPosition.m_122173_(Direction.DOWN);
                        if (!destWorld.m_6425_((BlockPos)currentPosition).m_76153_((Tag)FluidTags.f_13131_) || !this.checkRegionForPlacement((BlockPos)currentPosition, (Level)destWorld)) continue;
                        return currentPosition.m_7949_();
                    }
                }
            }
        }
        Panthalassa.LOGGER.error("Panthalassa: Unable to find valid portal location after searching {} radius. Force spawning portal regardless of conditions now.", (Object)radiusCheckLimit);
        return new BlockPos(originalPosition.m_123341_(), 64, originalPosition.m_123343_());
    }

    private BlockPortalBlockEntity getPortalTE(LevelAccessor world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof BlockPortalBlockEntity) {
            return (BlockPortalBlockEntity)tileEntity;
        }
        Panthalassa.LOGGER.error("Panthalassa: Failed to grab portal block entity from entity position for connecting the two portals");
        return null;
    }
}

