/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.codec;

import com.decursioteam.pickableorbs.codec.CodecUtils;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class OrbData {
    public static final OrbData DEFAULT = new OrbData("error");
    protected double blockDropChance;
    protected double entityDropChance;
    protected int effectMultiplier;
    protected int effectDuration;
    protected Set<Block> blockSet;
    protected Set<EntityType<?>> entitySet;
    protected String color;
    protected String name;
    protected String type;
    protected String blockListType;
    protected String entityListType;

    public static Codec<OrbData> codec(String name) {
        return RecordCodecBuilder.create(instance -> instance.group((App)MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(() -> name)).forGetter(OrbData::getName), (App)Codec.STRING.fieldOf("type").orElse((Object)"healing").forGetter(OrbData::getType), (App)Codec.intRange((int)0, (int)100).fieldOf("effectMultiplier").orElse((Object)1).forGetter(OrbData::getEffectMultiplier), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("effectDuration").orElse((Object)100).forGetter(OrbData::getEffectDuration), (App)Codec.STRING.fieldOf("color").forGetter(OrbData::getColor), (App)CodecUtils.BLOCK_SET_CODEC.fieldOf("blockList").orElse((Object)Sets.newHashSet((Object[])new Block[]{Blocks.f_50085_})).forGetter(OrbData::getBlockSet), (App)Codec.STRING.fieldOf("blockListType").orElse((Object)"whitelist").forGetter(OrbData::getBlockListType), (App)Codec.doubleRange((double)0.0, (double)100.0).fieldOf("blockDropChance").orElse((Object)0.0).forGetter(OrbData::getBlockDropChance), (App)CodecUtils.SET_FROM_ENTITY_LIST.fieldOf("entityList").orElse((Object)Sets.newHashSet((Object[])new EntityType[]{EntityType.f_20517_})).forGetter(OrbData::getEntitySet), (App)Codec.STRING.fieldOf("entityListType").orElse((Object)"whitelist").forGetter(OrbData::getEntityListType), (App)Codec.doubleRange((double)0.0, (double)100.0).fieldOf("entityDropChance").orElse((Object)0.0).forGetter(OrbData::getEntityDropChance)).apply((Applicative)instance, OrbData::new));
    }

    private OrbData(String name, String type, int effectMultiplier, int effectDuration, String color, Set<Block> blockSet, String blockListType, double blockDropChance, Set<EntityType<?>> entitySet, String entityListType, double entityDropChance) {
        this.name = name;
        this.effectDuration = effectDuration;
        this.effectMultiplier = effectMultiplier;
        this.type = type;
        this.blockDropChance = blockDropChance;
        this.entityDropChance = entityDropChance;
        this.blockListType = blockListType;
        this.entityListType = entityListType;
        this.color = color;
        this.blockSet = blockSet;
        this.entitySet = entitySet;
    }

    private OrbData(String name) {
        this.name = name;
        this.type = "healing";
        this.effectMultiplier = 1;
        this.effectDuration = 100;
        this.blockDropChance = 1.0;
        this.entityDropChance = 50.0;
        this.blockListType = "whitelist";
        this.entityListType = "blacklist";
        this.color = "#FF4500";
        this.blockSet = new HashSet<Block>();
        this.entitySet = new HashSet();
    }

    public int getEffectMultiplier() {
        return this.effectMultiplier;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public Set<Block> getBlockSet() {
        return this.blockSet;
    }

    public Set<EntityType<?>> getEntitySet() {
        return this.entitySet;
    }

    public double getBlockDropChance() {
        return this.blockDropChance;
    }

    public double getEntityDropChance() {
        return this.entityDropChance;
    }

    public String getColor() {
        return this.color;
    }

    public String getBlockListType() {
        return this.blockListType;
    }

    public String getEntityListType() {
        return this.entityListType;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public OrbData toImmutable() {
        return this;
    }

    public static class Mutable
    extends OrbData {
        public Mutable(String name, String type, int effectMultiplier, int effectDuration, String color, Set<Block> blockSet, String blockListType, double blockDropChance, Set<EntityType<?>> entitySet, String entityListType, double entityDropChance) {
            super(name, type, effectMultiplier, effectDuration, color, blockSet, blockListType, blockDropChance, entitySet, entityListType, entityDropChance);
        }

        public Mutable(String name) {
            super(name);
        }

        public Mutable setBlockDropChance(double blockDropChance) {
            this.blockDropChance = blockDropChance;
            return this;
        }

        public Mutable setEntityDropChance(double entityDropChance) {
            this.entityDropChance = entityDropChance;
            return this;
        }

        public Mutable setEffectMultiplier(int effectMultiplier) {
            this.effectMultiplier = effectMultiplier;
            return this;
        }

        public Mutable setEffectDuration(int effectDuration) {
            this.effectMultiplier = effectDuration;
            return this;
        }

        public Mutable setColor(String color) {
            this.color = color;
            return this;
        }

        public Mutable setBlockListType(String blockListType) {
            this.blockListType = blockListType;
            return this;
        }

        public Mutable setEntityListType(String entityListType) {
            this.entityListType = entityListType;
            return this;
        }

        public Mutable setBlockSet(Set<Block> blockSet) {
            this.blockSet = blockSet;
            return this;
        }

        public Mutable setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public OrbData toImmutable() {
            return new OrbData(this.name, this.type, this.effectMultiplier, this.effectDuration, this.color, this.blockSet, this.blockListType, this.blockDropChance, this.entitySet, this.entityListType, this.entityDropChance);
        }
    }
}

