/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.renderers;

import com.decursioteam.pickableorbs.codec.ExtraOptions;
import com.decursioteam.pickableorbs.codec.OrbData;
import com.decursioteam.pickableorbs.entities.HalfHeartEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HalfHeartRenderer
extends EntityRenderer<HalfHeartEntity> {
    private static final ResourceLocation HALF_HEART_TEXTURE = new ResourceLocation("pickableorbs", "textures/entity/plain_orb.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)HALF_HEART_TEXTURE);
    protected final int r;
    protected final int g;
    protected final int b;
    protected final boolean animation;

    public HalfHeartRenderer(EntityRendererProvider.Context renderManagerIn, OrbData orbData, ExtraOptions extraData) {
        super(renderManagerIn);
        this.f_114477_ = 0.15f;
        if (!orbData.getColor().contains("#")) {
            String newColor = "#" + orbData.getColor();
            this.r = Color.decode(newColor).getRed();
            this.g = Color.decode(newColor).getGreen();
            this.b = Color.decode(newColor).getBlue();
        } else {
            this.r = Color.decode(orbData.getColor()).getRed();
            this.g = Color.decode(orbData.getColor()).getGreen();
            this.b = Color.decode(orbData.getColor()).getBlue();
        }
        this.animation = extraData.getAnimation();
        this.f_114478_ = 0.75f;
    }

    public boolean shouldRender(HalfHeartEntity p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    protected int getBlockLightLevel(HalfHeartEntity p_225624_1_, BlockPos p_225624_2_) {
        return Mth.m_14045_((int)(super.m_6086_((Entity)p_225624_1_, p_225624_2_) + 7), (int)0, (int)15);
    }

    public void render(HalfHeartEntity p_225623_1_, float p_225623_2_, float p_225623_3_, PoseStack p_225623_4_, MultiBufferSource p_225623_5_, int p_225623_6_) {
        p_225623_4_.m_85836_();
        int i = 1;
        float f = (float)(i % 4 * 16 + 0) / 64.0f;
        float f1 = (float)(i % 4 * 16 + 16) / 64.0f;
        float f2 = (float)(i / 4 * 16 + 0) / 64.0f;
        float f3 = (float)(i / 4 * 16 + 16) / 64.0f;
        float f8 = ((float)p_225623_1_.f_19797_ + p_225623_3_) / 2.0f;
        int R = (int)((Mth.m_14031_((float)(f8 + 0.0f)) + 1.0f) * 0.5f * (float)this.r);
        int G = (int)((Mth.m_14031_((float)(f8 + 0.0f)) + 1.0f) * 0.5f * (float)this.g);
        int B = (int)((Mth.m_14031_((float)(f8 + 0.0f)) + 1.0f) * 0.5f * (float)this.b);
        p_225623_4_.m_85837_(0.0, (double)0.1f, 0.0);
        p_225623_4_.m_85845_(this.f_114476_.m_114470_());
        p_225623_4_.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        p_225623_4_.m_85841_(0.3f, 0.3f, 0.3f);
        VertexConsumer ivertexbuilder = p_225623_5_.m_6299_(RENDER_TYPE);
        PoseStack.Pose matrixstack$entry = p_225623_4_.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_85861_();
        Matrix3f matrix3f = matrixstack$entry.m_85864_();
        if (this.animation) {
            HalfHeartRenderer.vertex(true, ivertexbuilder, matrix4f, matrix3f, -0.5f, -0.25f, R, G, B, f, f3, p_225623_6_);
            HalfHeartRenderer.vertex(true, ivertexbuilder, matrix4f, matrix3f, 0.5f, -0.25f, R, G, B, f1, f3, p_225623_6_);
            HalfHeartRenderer.vertex(true, ivertexbuilder, matrix4f, matrix3f, 0.5f, 0.75f, R, G, B, f1, f2, p_225623_6_);
            HalfHeartRenderer.vertex(true, ivertexbuilder, matrix4f, matrix3f, -0.5f, 0.75f, R, G, B, f, f2, p_225623_6_);
        } else {
            HalfHeartRenderer.vertex(false, ivertexbuilder, matrix4f, matrix3f, -0.5f, -0.25f, this.r, this.g, this.b, f, f3, p_225623_6_);
            HalfHeartRenderer.vertex(false, ivertexbuilder, matrix4f, matrix3f, 0.5f, -0.25f, this.r, this.g, this.b, f1, f3, p_225623_6_);
            HalfHeartRenderer.vertex(false, ivertexbuilder, matrix4f, matrix3f, 0.5f, 0.75f, this.r, this.g, this.b, f1, f2, p_225623_6_);
            HalfHeartRenderer.vertex(false, ivertexbuilder, matrix4f, matrix3f, -0.5f, 0.75f, this.r, this.g, this.b, f, f2, p_225623_6_);
        }
        p_225623_4_.m_85849_();
        super.m_7392_((Entity)p_225623_1_, p_225623_2_, p_225623_3_, p_225623_4_, p_225623_5_, p_225623_6_);
    }

    public ResourceLocation getTextureLocation(HalfHeartEntity p_110775_1_) {
        return HALF_HEART_TEXTURE;
    }

    private static void vertex(boolean animation, VertexConsumer bufferIn, Matrix4f matrixIn, Matrix3f matrixNormalIn, float x, float y, int red, int green, int blue, float texU, float texV, int packedLight) {
        if (animation) {
            bufferIn.m_85982_(matrixIn, x, y, 0.0f).m_6122_(red, green, blue, 155).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrixNormalIn, 0.0f, 1.0f, 0.0f).m_5752_();
        } else {
            bufferIn.m_85982_(matrixIn, x, y, 0.0f).m_6122_(red, green, blue, 255).m_7421_(texU, texV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrixNormalIn, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }
}

