/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.codec;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class CodecUtils {
    public static final Codec<Set<Block>> SET_FROM_BLOCK_LIST = Registry.f_122824_.m_194605_().listOf().xmap(HashSet::new, ArrayList::new);
    public static final Codec<Set<EntityType<?>>> SET_FROM_ENTITY_LIST = Registry.f_122826_.m_194605_().listOf().xmap(HashSet::new, ArrayList::new);
    public static final Codec<Set<Block>> SET_FROM_BLOCK_TAG = Codec.STRING.comapFlatMap(CodecUtils::convertBlockTagToSet, CodecUtils::convertTagSetToString);
    public static final Codec<Set<Block>> BLOCK_SET_FROM_FLUID_TAG = Codec.STRING.comapFlatMap(CodecUtils::convertFluidTagToBlockSet, CodecUtils::convertTagSetToString);
    public static final Codec<Set<Block>> BLOCK_SET_CODEC = Codec.either((Codec)Codec.either(SET_FROM_BLOCK_TAG, BLOCK_SET_FROM_FLUID_TAG).xmap(either -> (Set)either.map(list -> list, list -> list), Either::left), SET_FROM_BLOCK_LIST).xmap(either -> (Set)either.map(list -> list, list -> list), Either::left);

    public static Optional<ResourceLocation> getResourceLocation(String resource) {
        return Optional.ofNullable(ResourceLocation.m_135820_((String)resource));
    }

    @Nullable
    public static Tag<Fluid> getFluidTag(String fluidTag) {
        return CodecUtils.getResourceLocation(fluidTag).map(arg_0 -> ((TagCollection)FluidTags.m_144299_()).m_13404_(arg_0)).orElse(null);
    }

    @Nullable
    public static Tag<Block> getBlockTag(String blockTag) {
        return CodecUtils.getResourceLocation(blockTag).map(arg_0 -> ((TagCollection)BlockTags.m_13115_()).m_13404_(arg_0)).orElse(null);
    }

    private static DataResult<Set<Block>> convertFluidTagToBlockSet(String input) {
        Tag<Fluid> tag = CodecUtils.getFluidTag(input);
        return tag != null ? DataResult.success(tag.m_6497_().stream().map(fluid -> fluid.m_76145_().m_76188_().m_60734_()).collect(Collectors.toSet())) : DataResult.success(new HashSet());
    }

    private static DataResult<Set<Block>> convertBlockTagToSet(String input) {
        Tag<Block> tag = CodecUtils.getBlockTag(input);
        return tag != null ? DataResult.success(new HashSet(tag.m_6497_())) : DataResult.success(new HashSet());
    }

    private static String convertTagSetToString(Set<?> set) {
        return Tag.m_13300_(set).toString();
    }

    public static <A> Codec<Set<A>> createSetCodec(Codec<A> codec) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new);
    }

    public static <A> Codec<Set<A>> createLinkedSetCodec(Codec<A> codec) {
        return codec.listOf().xmap(LinkedHashSet::new, LinkedList::new);
    }

    @SafeVarargs
    public static <E> Set<E> newLinkedHashSet(E ... elements) {
        return new LinkedHashSet<E>(Arrays.asList(elements));
    }
}

