/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.datagen;

import com.decursioteam.pickableorbs.PickableOrbs;
import com.decursioteam.pickableorbs.datagen.Orbs;
import com.decursioteam.pickableorbs.datagen.utils.IOrbsData;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class OrbsData
implements IOrbsData {
    private static final OrbsData INSTANCE = new OrbsData();
    private static final Map<String, JsonObject> RAW_DATA = new LinkedHashMap<String, JsonObject>();
    private static final Map<String, Orbs> CUSTOM_DATA = new LinkedHashMap<String, Orbs>();

    public static OrbsData getRegistry() {
        return INSTANCE;
    }

    public static Orbs getOrbData(ResourceLocation orbType) {
        return CUSTOM_DATA.getOrDefault(orbType.m_135815_().replaceAll("_orb$", ""), Orbs.DEFAULT);
    }

    public static Orbs getOrbData(String orbType) {
        return CUSTOM_DATA.getOrDefault(orbType, Orbs.DEFAULT);
    }

    public void regenerateCustomOrbsData() {
        RAW_DATA.forEach((s, jsonObject) -> CUSTOM_DATA.compute((String)s, (s1, orbData) -> (Orbs)Orbs.codec(s).parse((DynamicOps)JsonOps.INSTANCE, jsonObject).getOrThrow(false, s2 -> PickableOrbs.LOGGER.error("Couldn't create data for {} orb!", s))));
    }

    @Override
    public JsonObject getRawOrbsData(String orb) {
        return RAW_DATA.get(orb);
    }

    public void cacheRawOrbsData(String orbType, JsonObject orbData) {
        RAW_DATA.computeIfAbsent(orbType.toLowerCase(Locale.ENGLISH).replace(" ", "_"), s -> Objects.requireNonNull(orbData));
    }

    @Override
    public Map<String, JsonObject> getRawOrbs() {
        return Collections.unmodifiableMap(RAW_DATA);
    }

    @Override
    public Map<String, Orbs> getOrbs() {
        return Collections.unmodifiableMap(CUSTOM_DATA);
    }

    @Override
    public Set<Orbs> getSetOfOrbs() {
        return Collections.unmodifiableSet(new HashSet<Orbs>(CUSTOM_DATA.values()));
    }
}

