/*
 * Decompiled with CFR 0.152.
 */
package com.decursioteam.pickableorbs.registries;

import com.decursioteam.pickableorbs.PickableOrbs;
import com.decursioteam.pickableorbs.config.CommonConfig;
import com.decursioteam.pickableorbs.datagen.OrbsData;
import com.decursioteam.pickableorbs.datagen.utils.FileUtils;
import com.decursioteam.pickableorbs.entities.HalfHeartEntity;
import com.decursioteam.pickableorbs.registries.OrbsRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registry {
    public static final Gson GSON = new Gson();
    public static final SoundEvent GET_HEART_SOUND = (SoundEvent)new SoundEvent(new ResourceLocation("pickableorbs", "get_heart_sound")).setRegistryName("get_heart_sound");

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry soundEvents = event.getRegistry();
        soundEvents.register((IForgeRegistryEntry)GET_HEART_SOUND);
    }

    public static void registerOrbTypes() {
        OrbsData.getRegistry().getOrbs().forEach((name, data) -> Registry.registerOrb(name));
    }

    public static void registerOrb(String name) {
        EntityType orbType = EntityType.Builder.m_20704_((type, world) -> new HalfHeartEntity((EntityType<HalfHeartEntity>)type, world, name), (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_(name + "_orb");
        OrbsRegistry.ORB_TYPES.register(name + "_orb", () -> orbType);
        OrbsRegistry.getOrbs().put(name, (EntityType<? extends HalfHeartEntity>)orbType);
    }

    public static void setupDefaultOrbs() {
        if (((Boolean)CommonConfig.generate_defaults.get()).booleanValue()) {
            FileUtils.setupDefaultFiles("/data/pickableorbs/default_orbs", Registry.createCustomPath("orbs"));
        }
        PickableOrbs.LOGGER.info("Loading Orbs...");
        FileUtils.streamFilesAndParse(Registry.createCustomPath("orbs"), Registry::parseOrb, "Could not stream orbs!");
        OrbsData.getRegistry().regenerateCustomOrbsData();
    }

    public static void setupOrbs() {
        PickableOrbs.LOGGER.info("Loading Orbs...");
        FileUtils.streamFilesAndParse(Registry.createCustomPath("orbs"), Registry::parseOrb, "Could not stream orbs!");
        OrbsData.getRegistry().regenerateCustomOrbsData();
    }

    private static void parseOrb(Reader reader, String name) {
        JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
        name = (String)Codec.STRING.fieldOf("name").orElse((Object)name).codec().fieldOf("OrbData").codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).get().orThrow();
        OrbsData.getRegistry().cacheRawOrbsData(name.toLowerCase(Locale.ENGLISH).replace(" ", "_"), jsonObject);
    }

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "pickableorbs", pathName);
        Registry.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            PickableOrbs.LOGGER.error("failed to create \"{}\" directory", (Object)dirName);
        }
    }
}

