/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks;

import dev.arketec.redstonedirt.blocks.IRedstonePoweredPlantable;
import dev.arketec.redstonedirt.registration.ModBlocks;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public abstract class AbstractBlockRedstoneFarmland
extends FarmlandBlock
implements IRedstonePoweredPlantable {
    public static final int LIGHT_LEVEL = 5;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;

    public AbstractBlockRedstoneFarmland(int defaultPower, boolean defaultPowered, boolean strongPowered) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185849_b).func_235847_c_((s, r, p) -> true).func_235842_b_((s, r, p) -> true).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)POWERED) != false ? 5 : 0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(defaultPower))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(defaultPowered))).func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(0))).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(strongPowered)));
    }

    public abstract void func_225534_a_(BlockState var1, ServerWorld var2, BlockPos var3, Random var4);

    public abstract void func_225542_b_(BlockState var1, ServerWorld var2, BlockPos var3, Random var4);

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState blockState, boolean b) {
        if (!world.field_72995_K) {
            for (Direction dir : Direction.values()) {
                world.func_195593_d(pos.func_177972_a(dir), (Block)this);
            }
        }
        super.func_220082_b(state, world, pos, blockState, b);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState blockState, boolean b) {
        if (!b) {
            for (Direction dir : Direction.values()) {
                world.func_195593_d(pos.func_177972_a(dir), (Block)this);
            }
        }
        super.func_196243_a(state, world, pos, blockState, b);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float v) {
        entity.func_225503_b_(v, 1.0f);
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)ENABLED) != false ? this.func_180656_a(blockState, blockAccess, pos, side) : 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        BlockState state = blockAccess.func_180495_p(pos.func_177972_a(side.func_176734_d()));
        return this.shouldDecreasePower(state) ? (Integer)blockState.func_177229_b((Property)POWER) - 1 : (Integer)blockState.func_177229_b((Property)POWER);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER, POWERED, field_176531_a, ENABLED});
    }

    @Override
    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177971_a(facing.func_176730_m()));
        return type == PlantType.CROP;
    }

    protected boolean func_176529_d(IBlockReader reader, BlockPos pos) {
        BlockState plant = reader.func_180495_p(pos.func_177984_a());
        BlockState state = reader.func_180495_p(pos);
        return plant.func_177230_c() instanceof IPlantable && state.canSustainPlant(reader, pos, Direction.UP, (IPlantable)plant.func_177230_c());
    }

    protected static boolean isNearWater(IWorldReader reader, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!reader.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)reader, (BlockPos)pos);
    }

    public void setBlockState(World world, BlockPos pos, BlockState newState) {
        world.func_175656_a(pos, newState);
    }

    protected boolean shouldDecreasePower(BlockState blockState) {
        if (blockState.func_177230_c() instanceof RedstoneWireBlock) {
            return true;
        }
        return blockState.func_203425_a((Block)ModBlocks.REDSTONE_DIRT.get()) || blockState.func_203425_a((Block)ModBlocks.REDSTONE_GRASS.get()) || blockState.func_203425_a((Block)ModBlocks.REDSTONE_FARMLAND.get()) || blockState.func_203425_a((Block)ModBlocks.REDSTONE_GRASS_PATH.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        VoxelShape shape;
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && !(shape = state.func_196954_c((IBlockReader)world, pos)).func_197766_b()) {
            AxisAlignedBB bounds = shape.func_197752_a();
            double x = (double)pos.func_177958_n() + bounds.field_72340_a + random.nextDouble() * (bounds.field_72336_d - bounds.field_72340_a);
            double y = (double)pos.func_177956_o() + bounds.field_72338_b + random.nextDouble() * (bounds.field_72337_e - bounds.field_72338_b);
            double z = (double)pos.func_177952_p() + bounds.field_72339_c + random.nextDouble() * (bounds.field_72334_f - bounds.field_72339_c);
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

