/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks;

import dev.arketec.redstonedirt.blocks.AbstractBlockRedstoneGrass;
import dev.arketec.redstonedirt.registration.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockRedstoneGrass
extends AbstractBlockRedstoneGrass {
    public BlockRedstoneGrass() {
        super(0, false, false);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult hit) {
        if (hand.name().equals(Hand.MAIN_HAND.name())) {
            ItemStack held = playerEntity.func_184586_b(hand);
            if (held.func_77973_b() instanceof HoeItem && world.func_175623_d(pos.func_177984_a())) {
                held.func_222118_a(1, (LivingEntity)playerEntity, e -> e.func_213334_d(hand));
                world.func_175656_a(pos, ((Block)ModBlocks.REDSTONE_FARMLAND.get()).func_176223_P());
                return ActionResultType.SUCCESS;
            }
            if (held.func_77973_b() instanceof ShovelItem && world.func_175623_d(pos.func_177984_a())) {
                held.func_222118_a(1, (LivingEntity)playerEntity, e -> e.func_213334_d(hand));
                world.func_175656_a(pos, ((Block)ModBlocks.REDSTONE_GRASS_PATH.get()).func_176223_P());
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, playerEntity, hand, hit);
    }

    public void func_220069_a(BlockState blockState, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.func_201670_d()) {
            if (world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a())) {
                BlockState newState = this.updatePowerStrength(world, pos, blockState);
                world.func_184138_a(pos, newState, newState, 19);
            } else {
                this.setBlockState(world, pos, this.func_176223_P());
                world.func_184138_a(pos, this.func_176223_P(), this.func_176223_P(), 19);
            }
        }
        super.func_220069_a(blockState, world, pos, block, fromPos, isMoving);
    }

    @Override
    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState blockState, boolean b) {
        if (!blockState.func_203425_a(state.func_177230_c()) && !world.func_201670_d()) {
            BlockState newState = this.updatePowerStrength(world, pos, state);
            world.func_184138_a(pos, newState, newState, 19);
        }
        super.func_220082_b(state, world, pos, blockState, b);
    }

    @Override
    public BlockState updatePowerStrength(World world, BlockPos pos, BlockState state) {
        int strength;
        int neighborPower = world.func_175687_A(pos);
        int j = 0;
        if (neighborPower < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState blockstate = world.func_180495_p(blockpos);
                j = Math.max(j, this.getBlockSignal(blockstate));
                BlockPos above = pos.func_177984_a();
                if (blockstate.func_215686_e((IBlockReader)world, blockpos) && !world.func_180495_p(above).func_215686_e((IBlockReader)world, above)) {
                    j = Math.max(j, this.getBlockSignal(world.func_180495_p(above)));
                    continue;
                }
                if (blockstate.func_215686_e((IBlockReader)world, blockpos)) continue;
                j = Math.max(j, this.getBlockSignal(world.func_180495_p(blockpos.func_177977_b())));
            }
        }
        BlockState newState = (BlockState)((BlockState)state.func_206870_a((Property)POWERED, (Comparable)((strength = Math.max(neighborPower, j - 1)) > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)))).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(strength));
        if ((Integer)state.func_177229_b((Property)POWER) != strength && world.func_180495_p(pos) == state) {
            this.setBlockState(world, pos, newState);
        }
        return newState;
    }

    private int getBlockSignal(BlockState state) {
        return state.func_203425_a((Block)this) ? (Integer)state.func_177229_b((Property)POWER) : 0;
    }
}

