/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks.tile;

import dev.arketec.redstonedirt.blocks.IRedstonePoweredPlantable;
import dev.arketec.redstonedirt.blocks.tile.TileBase;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public abstract class TileDetectorBase
extends TileBase
implements ITickableTileEntity {
    private static final int _tickModulus = 10;
    private int _tickCounter = 0;

    public TileDetectorBase(TileEntityType te) {
        super(te);
    }

    public void func_73660_a() {
        if (++this._tickCounter % 10 != 0) {
            return;
        }
        this._tickCounter = 0;
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.tickAction(blockState);
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = this.field_174879_c.func_177972_a(direction);
                if (!(blockState.func_177230_c() instanceof IRedstonePoweredPlantable)) continue;
                ((IRedstonePoweredPlantable)blockState.func_177230_c()).updatePowerStrength(this.field_145850_b, blockpos, blockState);
            }
        }
    }

    protected abstract void tickAction(BlockState var1);

    protected boolean isUnderCrops(World world, BlockPos pos) {
        BlockState plant = world.func_180495_p(pos.func_177984_a());
        BlockState state = world.func_180495_p(pos);
        return plant.func_177230_c() instanceof IPlantable && state.canSustainPlant((IBlockReader)world, pos, Direction.UP, (IPlantable)plant.func_177230_c());
    }

    protected boolean isUnderSapling(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof SaplingBlock;
    }

    protected boolean isUnderTree(World world, BlockPos pos) {
        BlockState blockStateAbove = world.func_180495_p(pos.func_177984_a());
        Set tagsBlockAbove = blockStateAbove.func_177230_c().getTags();
        ResourceLocation logsTag = new ResourceLocation("minecraft", "logs");
        return this.anyMatchTag(logsTag, tagsBlockAbove);
    }

    private boolean anyMatchTag(ResourceLocation tag, Set<ResourceLocation> setOfTags) {
        for (ResourceLocation t : setOfTags) {
            if (t.compareTo(tag) != 0) continue;
            return true;
        }
        return false;
    }
}

