/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks;

import dev.arketec.redstonedirt.blocks.IRedstonePoweredPlantable;
import dev.arketec.redstonedirt.registration.ModBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public abstract class AbstractBlockRedstoneFarmland
extends FarmBlock
implements IRedstonePoweredPlantable {
    public static final int LIGHT_LEVEL = 5;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public AbstractBlockRedstoneFarmland(int defaultPower, boolean defaultPowered, boolean strongPowered) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76314_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56739_).m_60971_((s, r, p) -> true).m_60960_((s, r, p) -> true).m_60953_(state -> (Boolean)state.m_61143_((Property)POWERED) != false ? 5 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(defaultPower))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(defaultPowered))).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(strongPowered)));
    }

    public abstract void m_7458_(BlockState var1, ServerLevel var2, BlockPos var3, Random var4);

    public abstract void m_7455_(BlockState var1, ServerLevel var2, BlockPos var3, Random var4);

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState blockState, boolean b) {
        if (!world.f_46443_) {
            for (Direction dir : Direction.values()) {
                world.m_46672_(pos.m_142300_(dir), (Block)this);
            }
        }
        super.m_6807_(state, world, pos, blockState, b);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState blockState, boolean b) {
        if (!b) {
            for (Direction dir : Direction.values()) {
                world.m_46672_(pos.m_142300_(dir), (Block)this);
            }
        }
        super.m_6810_(state, world, pos, blockState, b);
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float v) {
        entity.m_142535_(v, 1.0f, DamageSource.f_19315_);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)ENABLED) != false ? this.m_6378_(blockState, blockAccess, pos, side) : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockState state = blockAccess.m_8055_(pos.m_142300_(side.m_122424_()));
        return this.shouldDecreasePower(state) ? (Integer)blockState.m_61143_((Property)POWER) - 1 : (Integer)blockState.m_61143_((Property)POWER);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER, POWERED, f_53243_, ENABLED});
    }

    @Override
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_141952_(facing.m_122436_()));
        return type == PlantType.CROP;
    }

    protected boolean m_53250_(BlockGetter reader, BlockPos pos) {
        BlockState plant = reader.m_8055_(pos.m_7494_());
        BlockState state = reader.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(reader, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    protected static boolean isNearWater(LevelReader reader, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-4, 0, -4), (BlockPos)pos.m_142082_(4, 1, 4))) {
            if (!reader.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)reader, (BlockPos)pos);
    }

    public void setBlockState(Level world, BlockPos pos, BlockState newState) {
        world.m_46597_(pos, newState);
    }

    protected boolean shouldDecreasePower(BlockState blockState) {
        if (blockState.m_60734_() instanceof RedStoneWireBlock) {
            return true;
        }
        return blockState.m_60713_((Block)ModBlocks.REDSTONE_DIRT.get()) || blockState.m_60713_((Block)ModBlocks.REDSTONE_GRASS.get()) || blockState.m_60713_((Block)ModBlocks.REDSTONE_FARMLAND.get()) || blockState.m_60713_((Block)ModBlocks.REDSTONE_GRASS_PATH.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        VoxelShape shape;
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !(shape = state.m_60808_((BlockGetter)world, pos)).m_83281_()) {
            AABB bounds = shape.m_83215_();
            double x = (double)pos.m_123341_() + bounds.f_82288_ + random.nextDouble() * (bounds.f_82291_ - bounds.f_82288_);
            double y = (double)pos.m_123342_() + bounds.f_82289_ + random.nextDouble() * (bounds.f_82292_ - bounds.f_82289_);
            double z = (double)pos.m_123343_() + bounds.f_82290_ + random.nextDouble() * (bounds.f_82293_ - bounds.f_82290_);
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

