/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks;

import dev.arketec.redstonedirt.blocks.AbstractBlockRedstoneFarmland;
import dev.arketec.redstonedirt.registration.ModBlocks;
import dev.arketec.redstonedirt.util.DirtHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;

public class BlockRedstoneFarmland
extends AbstractBlockRedstoneFarmland {
    public BlockRedstoneFarmland() {
        super(0, false, false);
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            DirtHelper.turnToRedstoneDirt(state, (Level)world, pos);
        }
    }

    @Override
    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        int i = (Integer)state.m_61143_((Property)f_53243_);
        if (!BlockRedstoneFarmland.m_53258_((LevelReader)world, (BlockPos)pos) && !world.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.m_53250_((BlockGetter)world, pos)) {
                DirtHelper.turnToRedstoneDirt(state, (Level)world, pos);
            }
        } else if (i < 7) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext itemUseContext) {
        return !this.m_49966_().m_60710_((LevelReader)itemUseContext.m_43725_(), itemUseContext.m_8083_()) ? ((Block)ModBlocks.REDSTONE_DIRT.get()).m_49966_() : super.m_5573_(itemUseContext);
    }

    @Override
    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float v) {
        if (!world.f_46443_ && ForgeHooks.onFarmlandTrample((Level)world, (BlockPos)pos, (BlockState)((Block)ModBlocks.REDSTONE_DIRT.get()).m_49966_(), (float)v, (Entity)entity)) {
            DirtHelper.turnToRedstoneDirt(world.m_8055_(pos), world, pos);
        }
        super.m_142072_(world, state, pos, entity, v);
    }

    public void m_6861_(BlockState blockState, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(blockState, world, pos, block, fromPos, isMoving);
        if (!world.m_5776_()) {
            if (world.m_46753_(pos) || world.m_46753_(pos.m_7494_())) {
                this.updatePowerStrength(world, pos, blockState);
            } else {
                this.setBlockState(world, pos, this.m_49966_());
            }
        }
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState blockState, boolean b) {
        if (!blockState.m_60713_(state.m_60734_()) && !world.m_5776_()) {
            this.updatePowerStrength(world, pos, state);
            super.m_6807_(state, world, pos, blockState, b);
        }
    }

    @Override
    public BlockState updatePowerStrength(Level world, BlockPos pos, BlockState state) {
        int neighborPower = world.m_46755_(pos);
        int j = 0;
        if (neighborPower < 15) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.m_142300_(direction);
                BlockState blockstate = world.m_8055_(blockpos);
                j = Math.max(j, this.getBlockSignal(blockstate));
                BlockPos above = pos.m_7494_();
                if (blockstate.m_60796_((BlockGetter)world, blockpos) && !world.m_8055_(above).m_60796_((BlockGetter)world, above)) {
                    j = Math.max(j, this.getBlockSignal(world.m_8055_(above)));
                    continue;
                }
                if (blockstate.m_60796_((BlockGetter)world, blockpos)) continue;
                j = Math.max(j, this.getBlockSignal(world.m_8055_(blockpos.m_7495_())));
            }
        }
        int strength = Math.max(neighborPower, j - 1);
        boolean isBestNeighborThis = false;
        for (BlockPos direction : Direction.values()) {
            if (world.m_46681_(pos.m_142300_((Direction)direction), (Direction)direction) != neighborPower) continue;
            BlockState blockState = world.m_8055_(pos.m_142300_((Direction)direction));
            if (blockState.m_60713_((Block)this)) {
                isBestNeighborThis = true;
                continue;
            }
            if (!isBestNeighborThis) continue;
            isBestNeighborThis = false;
            break;
        }
        if (isBestNeighborThis && strength == neighborPower) {
            strength = Math.max(0, strength - 1);
        }
        BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)(strength > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(strength));
        if ((Integer)state.m_61143_((Property)POWER) != strength && world.m_8055_(pos) == state) {
            this.setBlockState(world, pos, newState);
        }
        return newState;
    }

    private int getBlockSignal(BlockState state) {
        return state.m_60713_((Block)this) ? (Integer)state.m_61143_((Property)POWER) : 0;
    }
}

