/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks.tile;

import dev.arketec.redstonedirt.blocks.IRedstonePoweredPlantable;
import dev.arketec.redstonedirt.blocks.tile.TileBase;
import dev.arketec.redstonedirt.configuration.ModConfig;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;

public abstract class TileDetectorBase
extends TileBase {
    private static final int _tickModulus = 10;
    private int _tickCounter = 0;

    public TileDetectorBase(BlockEntityType te, BlockPos pos, BlockState blockState) {
        super(te, pos, blockState);
    }

    public void tickServer() {
        if (++this._tickCounter % 10 != 0) {
            return;
        }
        this._tickCounter = 0;
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
            this.tickAction(blockState);
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = this.f_58858_.m_142300_(direction);
                if (!(blockState.m_60734_() instanceof IRedstonePoweredPlantable)) continue;
                ((IRedstonePoweredPlantable)blockState.m_60734_()).updatePowerStrength(this.f_58857_, blockpos, blockState);
            }
        }
    }

    protected abstract void tickAction(BlockState var1);

    protected boolean isUnderCrops(Level world, BlockPos pos) {
        BlockState plant = world.m_8055_(pos.m_7494_());
        BlockState state = world.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant((BlockGetter)world, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    protected boolean isUnderSapling(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos.m_7494_());
        return state.m_60734_() instanceof SaplingBlock;
    }

    protected boolean isUnderTree(Level world, BlockPos pos) {
        BlockState blockStateAbove = world.m_8055_(pos.m_7494_());
        Set tagsBlockAbove = blockStateAbove.m_60734_().getTags();
        ResourceLocation logsTag = new ResourceLocation("minecraft", "logs");
        return this.anyMatchTag(logsTag, tagsBlockAbove);
    }

    protected boolean isWithinRange(Level world, BlockPos pos) {
        int range = (Integer)ModConfig.detectorRange.get();
        return pos.m_123342_() < this.f_58858_.m_123342_() + range - 1;
    }

    private boolean anyMatchTag(ResourceLocation tag, Set<ResourceLocation> setOfTags) {
        for (ResourceLocation t : setOfTags) {
            if (t.compareTo(tag) != 0) continue;
            return true;
        }
        return false;
    }
}

