/*
 * Decompiled with CFR 0.152.
 */
package dev.arketec.redstonedirt.blocks;

import dev.arketec.redstonedirt.blocks.IRedstonePoweredPlantable;
import dev.arketec.redstonedirt.registration.ModBlocks;
import dev.arketec.redstonedirt.util.DirtHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public abstract class AbstractBlockRedstoneGrass
extends GrassBlock
implements IRedstonePoweredPlantable {
    public static final int LIGHT_LEVEL = 5;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;

    public AbstractBlockRedstoneGrass(int defaultPower, boolean defaultPowered, boolean strongPowered) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56740_).m_60953_(state -> (Boolean)state.m_61143_((Property)POWERED) != false ? 5 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(defaultPower))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(defaultPowered))).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(strongPowered)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult hit) {
        return super.m_6227_(state, world, pos, playerEntity, hand, hit);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        if (!world.f_46443_) {
            if (!world.isAreaLoaded(pos, 2)) {
                return;
            }
            if (!AbstractBlockRedstoneGrass.canBeGrass(state, (LevelReader)world, pos)) {
                DirtHelper.turnToRedstoneDirt(state, (Level)world, pos);
            } else if (world.m_46803_(pos.m_7494_()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_142082_(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (!AbstractBlockRedstoneGrass.canPropagate(this.m_49966_(), (LevelReader)world, blockpos) || !world.m_8055_(blockpos).m_60713_(Blocks.f_50493_)) continue;
                    DirtHelper.turnToGrass(state, (Level)world, blockpos);
                }
            }
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState blockState, boolean b) {
        if (!world.f_46443_) {
            for (Direction dir : Direction.values()) {
                world.m_46672_(pos.m_142300_(dir), (Block)this);
            }
        }
        super.m_6807_(state, world, pos, blockState, b);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState blockState, boolean b) {
        if (!b) {
            for (Direction dir : Direction.values()) {
                world.m_46672_(pos.m_142300_(dir), (Block)this);
            }
        }
        super.m_6810_(state, world, pos, blockState, b);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)ENABLED) != false ? this.m_6378_(blockState, blockAccess, pos, side) : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockState state = blockAccess.m_8055_(pos.m_142300_(side.m_122424_()));
        return this.shouldDecreasePower(state) ? (Integer)blockState.m_61143_((Property)POWER) - 1 : (Integer)blockState.m_61143_((Property)POWER);
    }

    @Override
    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER, POWERED, ENABLED, f_56637_});
    }

    @Override
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.m_141952_(facing.m_122436_()));
        return type == PlantType.PLAINS || type == PlantType.BEACH || plantable instanceof StemBlock;
    }

    public BlockState getFullPoweredState(BlockState state) {
        return (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(15));
    }

    public void setBlockState(Level world, BlockPos pos, BlockState newState) {
        world.m_46597_(pos, newState);
    }

    protected boolean shouldDecreasePower(BlockState blockState) {
        if (blockState.m_60734_() instanceof RedStoneWireBlock) {
            return true;
        }
        return blockState.m_60713_((Block)ModBlocks.REDSTONE_DIRT.get()) || blockState.m_60713_((Block)ModBlocks.REDSTONE_GRASS.get()) || blockState.m_60713_((Block)ModBlocks.REDSTONE_FARMLAND.get()) || blockState.m_60713_((Block)ModBlocks.REDSTONE_GRASS_PATH.get());
    }

    private static boolean canBeGrass(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = reader.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50125_) && (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)reader, blockpos));
        return i < reader.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader reader, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return AbstractBlockRedstoneGrass.canBeGrass(state, reader, pos) && !reader.m_6425_(blockpos).m_76153_((Tag)FluidTags.f_13131_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random r) {
        VoxelShape shape;
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !(shape = state.m_60808_((BlockGetter)world, pos)).m_83281_()) {
            AABB localBox = shape.m_83215_();
            double x = (double)pos.m_123341_() + localBox.f_82288_ + r.nextDouble() * (localBox.f_82291_ - localBox.f_82288_);
            double y = (double)pos.m_123342_() + localBox.f_82289_ + r.nextDouble() * (localBox.f_82292_ - localBox.f_82289_);
            double z = (double)pos.m_123343_() + localBox.f_82290_ + r.nextDouble() * (localBox.f_82293_ - localBox.f_82290_);
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

